# UA-L2O

## Dependencies
+ [TensorFlow >=1.14](https://www.tensorflow.org/)
+ [Sonnet >=1.0](https://github.com/deepmind/sonnet)
+ [Tensorflow Probability=0.7.0](https://www.tensorflow.org/probability) 

## Environment Preparation:
 1. `conda env create -f environment.yml`
 2.  modify sonnet files:
       + go to 'sonnet_modified_files' directory.
       + Copy two files: 'basic.py'  'gated_rnn.py' into the directory shown in the README there.


## Training Commands:

Stage 1:
`python train_dm_rs_cl.py --problem $problem_name --stage 1 --save_path $path_to_your_saved_model` 

Stage 2:
`python train_dm_rs_cl.py --problem $problem_name --stage 2 --restore $path_to_your_saved_stage1_model --path $path_to_your_saved_model`

For instance,
 + $problem_name = rastrigin06, rastrigin12, rastrigin18, rastrigin24, rastrigin30 means train on test function rastrigin on dim=6, 12, 18, 24, 30, respectively.
 + $problem_name = ackley06, ackley12, ackley18, ackley24, ackley30.
 + $problem_name = griewank06, griewank12, griewank18, griewank24, griewank30.
 + $problem_name = privacy_attack means privacy_attack experiment.
 + $problem_name = protein_dock means protein docking experiment.


## Evaluation Commands:
`python evaluate.py --problem $problem_name --path $path_to_your_saved_stage2_model --output $path_to_your_output_text_file`


PS: For protein docking, we suggest add two more arugments for training: `--learning_rate 1E-5 --num_steps 600` and one more argument for evaluation: `--num_steps 600`.

