#include <filesystem>
#include <fstream>
#include <iostream>
#include <limits>
#include <vector>

#include "algorithm/greedy.hpp"
#include "io.hpp"
#include "oracle.hpp"
#include "strategy.hpp"

using namespace std;
using namespace filesystem;
using namespace Eigen;

template<class S>
void run(const MatrixXd& L, const path& fpath)
{
    const int n       = L.cols();
    const auto result = greedy<S, Fast>(L, {numeric_limits<double>::infinity(), 0, true}).last();

    vector<int> inv(n, -1);
    int t;
    for(t = 0; t < int(result.solution.size()); ++t) {
        inv[result.solution[t]] = t;
    }
    for(int i = 0; i < n; ++i) {
        if(inv[i] == -1) {
            inv[i] = t;
            ++t;
        }
    }

    create_directories(fpath.parent_path());
    ofstream fout(fpath);
    fout << n << ' ' << result.computed_offdiagonals_V.size() << '\n';

    for(const auto& [i, j] : result.computed_offdiagonals_V) {
        fout << inv[i] << ' ' << inv[j] << '\n';
    }
}

int main()
{
    /*
    {
        const auto L = load_symmetric_matrix("./data/netflix/L.txt");
        run<Lazy>(L, "./result/offdiagonals/netflix-Lazy.txt");
    }
    */

    {
        const auto L = load_symmetric_matrix("./data/movie_lens/L.txt");
        run<Lazy>(L, "./result/offdiagonals/movie_lens-Lazy.txt");
    }
}
