#include <cstdlib>
#include <iostream>
#include <string>

#include "algorithm/greedy.hpp"
#include "io.hpp"
#include "oracle.hpp"
#include "strategy.hpp"

using namespace std;

int main(const int argc, const char *const *const argv)
{
    if(argc < 2 || (argv[1] != string("fast") && argv[1] != string("lazyfast"))) {
        cerr << R"(Give "fast" or "lazyfast" as an argument)" << endl;
        return EXIT_FAILURE;
    }

    const auto L  = load_symmetric_matrix("./data/wishart/6000/L.txt");
    Result result = Result::unfinished();

    if(argv[1] == string("fast")) {
        cout << "Running Fast..." << endl;
        result = greedy<NonLazy, Fast>(L).last();
    }
    else if(argv[1] == string("lazyfast")) {
        cout << "Running LazyFast..." << endl;
        result = greedy<Lazy, Fast>(L).last();
    }

    cout << "Time: " << result.time << endl;
    cout << "Function value: " << result.value << endl;
}
