%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%                                                                  %%%%%
%%%%    IEEE PES Power Grid Library - Optimal Power Flow - v23.07     %%%%%
%%%%          (https://github.com/power-grid-lib/pglib-opf)           %%%%%
%%%%               Benchmark Group - Typical Operations               %%%%%
%%%%                         23 - July - 2023                         %%%%%
%%%%                                                                  %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%   Power flow data for IEEE 118 bus test case.
%   Please see CASEFORMAT for details on the case file format.
%   (ieee118cdf.txt) on 20-Sep-2004 by cdf2matp, rev. 1.11
%
%   Converted from IEEE CDF file from:
%       http://www.ee.washington.edu/research/pstca/
%   
%   With base_kV data take from the PSAP format file from the same site,
%   added manually on 10-Mar-2006.
%
%   Copyright (c) 1999 by Richard D. Christie, University of Washington
%   Electrical Engineering Licensed under the Creative Commons Attribution 4.0
%   International license, http://creativecommons.org/licenses/by/4.0/
%
%   CDF Header:
%   08/25/93 UW ARCHIVE           100.0  1961 W IEEE 118 Bus Test Case
%
function mpc = pglib_opf_case118_ieee
mpc.version = '2';
mpc.baseMVA = 100.0;

%% bus data
%	bus_i	type	Pd	Qd	Gs	Bs	area	Vm	Va	baseKV	zone	Vmax	Vmin
mpc.bus = [
	1	 2	 51.0	 27.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	2	 1	 20.0	 9.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	3	 1	 39.0	 10.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	4	 2	 39.0	 12.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	5	 1	 0.0	 0.0	 0.0	 -40.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	6	 2	 52.0	 22.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	7	 1	 19.0	 2.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	8	 2	 28.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.06000	    0.94000;
	9	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.06000	    0.94000;
	10	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.06000	    0.94000;
	11	 1	 70.0	 23.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	12	 2	 47.0	 10.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	13	 1	 34.0	 16.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	14	 1	 14.0	 1.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	15	 2	 90.0	 30.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	16	 1	 25.0	 10.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	17	 1	 11.0	 3.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	18	 2	 60.0	 34.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	19	 2	 45.0	 25.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	20	 1	 18.0	 3.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	21	 1	 14.0	 8.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	22	 1	 10.0	 5.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	23	 1	 7.0	 3.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	24	 2	 13.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	25	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	26	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.06000	    0.94000;
	27	 2	 71.0	 13.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	28	 1	 17.0	 7.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	29	 1	 24.0	 4.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	30	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.06000	    0.94000;
	31	 2	 43.0	 27.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	32	 2	 59.0	 23.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	33	 1	 23.0	 9.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	34	 2	 59.0	 26.0	 0.0	 14.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	35	 1	 33.0	 9.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	36	 2	 31.0	 17.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	37	 1	 0.0	 0.0	 0.0	 -25.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	38	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.06000	    0.94000;
	39	 1	 27.0	 11.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	40	 2	 66.0	 23.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	41	 1	 37.0	 10.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	42	 2	 96.0	 23.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	43	 1	 18.0	 7.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	44	 1	 16.0	 8.0	 0.0	 10.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	45	 1	 53.0	 22.0	 0.0	 10.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	46	 2	 28.0	 10.0	 0.0	 10.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	47	 1	 34.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	48	 1	 20.0	 11.0	 0.0	 15.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	49	 2	 87.0	 30.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	50	 1	 17.0	 4.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	51	 1	 17.0	 8.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	52	 1	 18.0	 5.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	53	 1	 23.0	 11.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	54	 2	 113.0	 32.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	55	 2	 63.0	 22.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	56	 2	 84.0	 18.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	57	 1	 12.0	 3.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	58	 1	 12.0	 3.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	59	 2	 277.0	 113.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	60	 1	 78.0	 3.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	61	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	62	 2	 77.0	 14.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	63	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.06000	    0.94000;
	64	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.06000	    0.94000;
	65	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.06000	    0.94000;
	66	 2	 39.0	 18.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	67	 1	 28.0	 7.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	68	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.06000	    0.94000;
	69	 3	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	70	 2	 66.0	 20.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	71	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	72	 2	 12.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	73	 2	 6.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	74	 2	 68.0	 27.0	 0.0	 12.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	75	 1	 47.0	 11.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	76	 2	 68.0	 36.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	77	 2	 61.0	 28.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	78	 1	 71.0	 26.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	79	 1	 39.0	 32.0	 0.0	 20.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	80	 2	 130.0	 26.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	81	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.06000	    0.94000;
	82	 1	 54.0	 27.0	 0.0	 20.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	83	 1	 20.0	 10.0	 0.0	 10.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	84	 1	 11.0	 7.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	85	 2	 24.0	 15.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	86	 1	 21.0	 10.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	87	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 161.0	 1	    1.06000	    0.94000;
	88	 1	 48.0	 10.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	89	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	90	 2	 163.0	 42.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	91	 2	 10.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	92	 2	 65.0	 10.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	93	 1	 12.0	 7.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	94	 1	 30.0	 16.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	95	 1	 42.0	 31.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	96	 1	 38.0	 15.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	97	 1	 15.0	 9.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	98	 1	 34.0	 8.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	99	 2	 42.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	100	 2	 37.0	 18.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	101	 1	 22.0	 15.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	102	 1	 5.0	 3.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	103	 2	 23.0	 16.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	104	 2	 38.0	 25.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	105	 2	 31.0	 26.0	 0.0	 20.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	106	 1	 43.0	 16.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	107	 2	 50.0	 12.0	 0.0	 6.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	108	 1	 2.0	 1.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	109	 1	 8.0	 3.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	110	 2	 39.0	 30.0	 0.0	 6.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	111	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	112	 2	 68.0	 13.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	113	 2	 6.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	114	 1	 8.0	 3.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	115	 1	 22.0	 7.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	116	 2	 184.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	117	 1	 20.0	 8.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
	118	 1	 33.0	 15.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.06000	    0.94000;
];

%% generator data
%	bus	Pg	Qg	Qmax	Qmin	Vg	mBase	status	Pmax	Pmin
mpc.gen = [
	1	 0.0	 5.0	 15.0	 -5.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	4	 0.0	 0.0	 300.0	 -300.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	6	 0.0	 18.5	 50.0	 -13.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	8	 0.0	 0.0	 300.0	 -300.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	10	 252.5	 26.5	 200.0	 -147.0	 1.0	 100.0	 1	 505	 0.0; % NG
	12	 42.5	 4.0	 43.0	 -35.0	 1.0	 100.0	 1	 85	 0.0; % PEL
	15	 0.0	 10.0	 30.0	 -10.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	18	 0.0	 17.0	 50.0	 -16.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	19	 0.0	 8.0	 24.0	 -8.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	24	 0.0	 0.0	 300.0	 -300.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	25	 110.5	 32.0	 111.0	 -47.0	 1.0	 100.0	 1	 221	 0.0; % NG
	26	 242.5	 0.0	 243.0	 -243.0	 1.0	 100.0	 1	 485	 0.0; % COW
	27	 0.0	 0.0	 300.0	 -300.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	31	 8.5	 0.0	 9.0	 -9.0	 1.0	 100.0	 1	 17	 0.0; % COW
	32	 0.0	 14.0	 42.0	 -14.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	34	 0.0	 8.0	 24.0	 -8.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	36	 0.0	 8.0	 24.0	 -8.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	40	 0.0	 0.0	 300.0	 -300.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	42	 0.0	 0.0	 300.0	 -300.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	46	 10.0	 0.0	 10.0	 -10.0	 1.0	 100.0	 1	 20	 0.0; % NG
	49	 111.5	 13.5	 112.0	 -85.0	 1.0	 100.0	 1	 223	 0.0; % NG
	54	 26.5	 0.0	 27.0	 -27.0	 1.0	 100.0	 1	 53	 0.0; % NG
	55	 0.0	 7.5	 23.0	 -8.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	56	 0.0	 3.5	 15.0	 -8.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	59	 154.0	 47.0	 154.0	 -60.0	 1.0	 100.0	 1	 308	 0.0; % NG
	61	 97.5	 0.0	 98.0	 -98.0	 1.0	 100.0	 1	 195	 0.0; % NG
	62	 0.0	 0.0	 20.0	 -20.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	65	 220.5	 66.5	 200.0	 -67.0	 1.0	 100.0	 1	 441	 0.0; % NG
	66	 392.0	 66.5	 200.0	 -67.0	 1.0	 100.0	 1	 784	 0.0; % COW
	69	 591.0	 0.0	 300.0	 -300.0	 1.0	 100.0	 1	 1182	 0.0; % COW
	70	 0.0	 11.0	 32.0	 -10.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	72	 0.0	 0.0	 100.0	 -100.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	73	 0.0	 0.0	 100.0	 -100.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	74	 0.0	 1.5	 9.0	 -6.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	76	 0.0	 7.5	 23.0	 -8.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	77	 0.0	 25.0	 70.0	 -20.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	80	 254.5	 45.0	 255.0	 -165.0	 1.0	 100.0	 1	 509	 0.0; % COW
	85	 0.0	 7.5	 23.0	 -8.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	87	 5.0	 0.0	 5.0	 -5.0	 1.0	 100.0	 1	 10	 0.0; % NG
	89	 318.5	 45.0	 300.0	 -210.0	 1.0	 100.0	 1	 637	 0.0; % COW
	90	 0.0	 0.0	 300.0	 -300.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	91	 0.0	 0.0	 100.0	 -100.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	92	 0.0	 3.0	 9.0	 -3.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	99	 0.0	 0.0	 100.0	 -100.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	100	 326.5	 52.5	 155.0	 -50.0	 1.0	 100.0	 1	 653	 0.0; % COW
	103	 54.0	 12.5	 40.0	 -15.0	 1.0	 100.0	 1	 108	 0.0; % NG
	104	 0.0	 7.5	 23.0	 -8.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	105	 0.0	 7.5	 23.0	 -8.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	107	 0.0	 0.0	 200.0	 -200.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	110	 0.0	 7.5	 23.0	 -8.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	111	 39.5	 0.0	 40.0	 -40.0	 1.0	 100.0	 1	 79	 0.0; % NG
	112	 0.0	 450.0	 1000.0	 -100.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	113	 0.0	 50.0	 200.0	 -100.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	116	 0.0	 0.0	 1000.0	 -1000.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
];

%% generator cost data
%	2	startup	shutdown	n	c(n-1)	...	c0
mpc.gencost = [
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	  24.983420	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	 124.581564	   0.000000; % PEL
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	  28.948321	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  22.220980	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	  25.993982	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	  24.202306	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  16.673942	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  27.277343	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	  24.861868	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  16.056042	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	  34.781778	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  32.668781	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  25.758442	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	  24.600772	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	  34.072633	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  24.605102	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	  12.612170	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  28.649471	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	  35.043401	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
];

%% branch data
%	fbus	tbus	r	x	b	rateA	rateB	rateC	ratio	angle	status	angmin	angmax
mpc.branch = [
	1	 2	 0.0303	 0.0999	 0.0254	 151	 151	 151	 0.0	 0.0	 1	 -30.0	 30.0;
	1	 3	 0.0129	 0.0424	 0.01082	 151	 151	 151	 0.0	 0.0	 1	 -30.0	 30.0;
	4	 5	 0.00176	 0.00798	 0.0021	 176	 176	 176	 0.0	 0.0	 1	 -30.0	 30.0;
	3	 5	 0.0241	 0.108	 0.0284	 175	 175	 175	 0.0	 0.0	 1	 -30.0	 30.0;
	5	 6	 0.0119	 0.054	 0.01426	 176	 176	 176	 0.0	 0.0	 1	 -30.0	 30.0;
	6	 7	 0.00459	 0.0208	 0.0055	 176	 176	 176	 0.0	 0.0	 1	 -30.0	 30.0;
	8	 9	 0.00244	 0.0305	 1.162	 711	 711	 711	 0.0	 0.0	 1	 -30.0	 30.0;
	8	 5	 0.0	 0.0267	 0.0	 1099	 1099	 1099	 0.985	 0.0	 1	 -30.0	 30.0;
	9	 10	 0.00258	 0.0322	 1.23	 710	 710	 710	 0.0	 0.0	 1	 -30.0	 30.0;
	4	 11	 0.0209	 0.0688	 0.01748	 151	 151	 151	 0.0	 0.0	 1	 -30.0	 30.0;
	5	 11	 0.0203	 0.0682	 0.01738	 152	 152	 152	 0.0	 0.0	 1	 -30.0	 30.0;
	11	 12	 0.00595	 0.0196	 0.00502	 151	 151	 151	 0.0	 0.0	 1	 -30.0	 30.0;
	2	 12	 0.0187	 0.0616	 0.01572	 151	 151	 151	 0.0	 0.0	 1	 -30.0	 30.0;
	3	 12	 0.0484	 0.16	 0.0406	 151	 151	 151	 0.0	 0.0	 1	 -30.0	 30.0;
	7	 12	 0.00862	 0.034	 0.00874	 164	 164	 164	 0.0	 0.0	 1	 -30.0	 30.0;
	11	 13	 0.02225	 0.0731	 0.01876	 151	 151	 151	 0.0	 0.0	 1	 -30.0	 30.0;
	12	 14	 0.0215	 0.0707	 0.01816	 151	 151	 151	 0.0	 0.0	 1	 -30.0	 30.0;
	13	 15	 0.0744	 0.2444	 0.06268	 115	 115	 115	 0.0	 0.0	 1	 -30.0	 30.0;
	14	 15	 0.0595	 0.195	 0.0502	 144	 144	 144	 0.0	 0.0	 1	 -30.0	 30.0;
	12	 16	 0.0212	 0.0834	 0.0214	 164	 164	 164	 0.0	 0.0	 1	 -30.0	 30.0;
	15	 17	 0.0132	 0.0437	 0.0444	 151	 151	 151	 0.0	 0.0	 1	 -30.0	 30.0;
	16	 17	 0.0454	 0.1801	 0.0466	 158	 158	 158	 0.0	 0.0	 1	 -30.0	 30.0;
	17	 18	 0.0123	 0.0505	 0.01298	 167	 167	 167	 0.0	 0.0	 1	 -30.0	 30.0;
	18	 19	 0.01119	 0.0493	 0.01142	 173	 173	 173	 0.0	 0.0	 1	 -30.0	 30.0;
	19	 20	 0.0252	 0.117	 0.0298	 178	 178	 178	 0.0	 0.0	 1	 -30.0	 30.0;
	15	 19	 0.012	 0.0394	 0.0101	 151	 151	 151	 0.0	 0.0	 1	 -30.0	 30.0;
	20	 21	 0.0183	 0.0849	 0.0216	 177	 177	 177	 0.0	 0.0	 1	 -30.0	 30.0;
	21	 22	 0.0209	 0.097	 0.0246	 178	 178	 178	 0.0	 0.0	 1	 -30.0	 30.0;
	22	 23	 0.0342	 0.159	 0.0404	 178	 178	 178	 0.0	 0.0	 1	 -30.0	 30.0;
	23	 24	 0.0135	 0.0492	 0.0498	 158	 158	 158	 0.0	 0.0	 1	 -30.0	 30.0;
	23	 25	 0.0156	 0.08	 0.0864	 186	 186	 186	 0.0	 0.0	 1	 -30.0	 30.0;
	26	 25	 0.0	 0.0382	 0.0	 768	 768	 768	 0.96	 0.0	 1	 -30.0	 30.0;
	25	 27	 0.0318	 0.163	 0.1764	 177	 177	 177	 0.0	 0.0	 1	 -30.0	 30.0;
	27	 28	 0.01913	 0.0855	 0.0216	 174	 174	 174	 0.0	 0.0	 1	 -30.0	 30.0;
	28	 29	 0.0237	 0.0943	 0.0238	 165	 165	 165	 0.0	 0.0	 1	 -30.0	 30.0;
	30	 17	 0.0	 0.0388	 0.0	 756	 756	 756	 0.96	 0.0	 1	 -30.0	 30.0;
	8	 30	 0.00431	 0.0504	 0.514	 580	 580	 580	 0.0	 0.0	 1	 -30.0	 30.0;
	26	 30	 0.00799	 0.086	 0.908	 340	 340	 340	 0.0	 0.0	 1	 -30.0	 30.0;
	17	 31	 0.0474	 0.1563	 0.0399	 151	 151	 151	 0.0	 0.0	 1	 -30.0	 30.0;
	29	 31	 0.0108	 0.0331	 0.0083	 146	 146	 146	 0.0	 0.0	 1	 -30.0	 30.0;
	23	 32	 0.0317	 0.1153	 0.1173	 158	 158	 158	 0.0	 0.0	 1	 -30.0	 30.0;
	31	 32	 0.0298	 0.0985	 0.0251	 151	 151	 151	 0.0	 0.0	 1	 -30.0	 30.0;
	27	 32	 0.0229	 0.0755	 0.01926	 151	 151	 151	 0.0	 0.0	 1	 -30.0	 30.0;
	15	 33	 0.038	 0.1244	 0.03194	 150	 150	 150	 0.0	 0.0	 1	 -30.0	 30.0;
	19	 34	 0.0752	 0.247	 0.0632	 114	 114	 114	 0.0	 0.0	 1	 -30.0	 30.0;
	35	 36	 0.00224	 0.0102	 0.00268	 176	 176	 176	 0.0	 0.0	 1	 -30.0	 30.0;
	35	 37	 0.011	 0.0497	 0.01318	 175	 175	 175	 0.0	 0.0	 1	 -30.0	 30.0;
	33	 37	 0.0415	 0.142	 0.0366	 154	 154	 154	 0.0	 0.0	 1	 -30.0	 30.0;
	34	 36	 0.00871	 0.0268	 0.00568	 146	 146	 146	 0.0	 0.0	 1	 -30.0	 30.0;
	34	 37	 0.00256	 0.0094	 0.00984	 159	 159	 159	 0.0	 0.0	 1	 -30.0	 30.0;
	38	 37	 0.0	 0.0375	 0.0	 783	 783	 783	 0.935	 0.0	 1	 -30.0	 30.0;
	37	 39	 0.0321	 0.106	 0.027	 151	 151	 151	 0.0	 0.0	 1	 -30.0	 30.0;
	37	 40	 0.0593	 0.168	 0.042	 140	 140	 140	 0.0	 0.0	 1	 -30.0	 30.0;
	30	 38	 0.00464	 0.054	 0.422	 542	 542	 542	 0.0	 0.0	 1	 -30.0	 30.0;
	39	 40	 0.0184	 0.0605	 0.01552	 151	 151	 151	 0.0	 0.0	 1	 -30.0	 30.0;
	40	 41	 0.0145	 0.0487	 0.01222	 152	 152	 152	 0.0	 0.0	 1	 -30.0	 30.0;
	40	 42	 0.0555	 0.183	 0.0466	 151	 151	 151	 0.0	 0.0	 1	 -30.0	 30.0;
	41	 42	 0.041	 0.135	 0.0344	 151	 151	 151	 0.0	 0.0	 1	 -30.0	 30.0;
	43	 44	 0.0608	 0.2454	 0.06068	 117	 117	 117	 0.0	 0.0	 1	 -30.0	 30.0;
	34	 43	 0.0413	 0.1681	 0.04226	 167	 167	 167	 0.0	 0.0	 1	 -30.0	 30.0;
	44	 45	 0.0224	 0.0901	 0.0224	 166	 166	 166	 0.0	 0.0	 1	 -30.0	 30.0;
	45	 46	 0.04	 0.1356	 0.0332	 153	 153	 153	 0.0	 0.0	 1	 -30.0	 30.0;
	46	 47	 0.038	 0.127	 0.0316	 152	 152	 152	 0.0	 0.0	 1	 -30.0	 30.0;
	46	 48	 0.0601	 0.189	 0.0472	 148	 148	 148	 0.0	 0.0	 1	 -30.0	 30.0;
	47	 49	 0.0191	 0.0625	 0.01604	 150	 150	 150	 0.0	 0.0	 1	 -30.0	 30.0;
	42	 49	 0.0715	 0.323	 0.086	 89	 89	 89	 0.0	 0.0	 1	 -30.0	 30.0;
	42	 49	 0.0715	 0.323	 0.086	 89	 89	 89	 0.0	 0.0	 1	 -30.0	 30.0;
	45	 49	 0.0684	 0.186	 0.0444	 138	 138	 138	 0.0	 0.0	 1	 -30.0	 30.0;
	48	 49	 0.0179	 0.0505	 0.01258	 140	 140	 140	 0.0	 0.0	 1	 -30.0	 30.0;
	49	 50	 0.0267	 0.0752	 0.01874	 140	 140	 140	 0.0	 0.0	 1	 -30.0	 30.0;
	49	 51	 0.0486	 0.137	 0.0342	 140	 140	 140	 0.0	 0.0	 1	 -30.0	 30.0;
	51	 52	 0.0203	 0.0588	 0.01396	 142	 142	 142	 0.0	 0.0	 1	 -30.0	 30.0;
	52	 53	 0.0405	 0.1635	 0.04058	 166	 166	 166	 0.0	 0.0	 1	 -30.0	 30.0;
	53	 54	 0.0263	 0.122	 0.031	 177	 177	 177	 0.0	 0.0	 1	 -30.0	 30.0;
	49	 54	 0.073	 0.289	 0.0738	 99	 99	 99	 0.0	 0.0	 1	 -30.0	 30.0;
	49	 54	 0.0869	 0.291	 0.073	 97	 97	 97	 0.0	 0.0	 1	 -30.0	 30.0;
	54	 55	 0.0169	 0.0707	 0.0202	 169	 169	 169	 0.0	 0.0	 1	 -30.0	 30.0;
	54	 56	 0.00275	 0.00955	 0.00732	 155	 155	 155	 0.0	 0.0	 1	 -30.0	 30.0;
	55	 56	 0.00488	 0.0151	 0.00374	 146	 146	 146	 0.0	 0.0	 1	 -30.0	 30.0;
	56	 57	 0.0343	 0.0966	 0.0242	 140	 140	 140	 0.0	 0.0	 1	 -30.0	 30.0;
	50	 57	 0.0474	 0.134	 0.0332	 140	 140	 140	 0.0	 0.0	 1	 -30.0	 30.0;
	56	 58	 0.0343	 0.0966	 0.0242	 140	 140	 140	 0.0	 0.0	 1	 -30.0	 30.0;
	51	 58	 0.0255	 0.0719	 0.01788	 140	 140	 140	 0.0	 0.0	 1	 -30.0	 30.0;
	54	 59	 0.0503	 0.2293	 0.0598	 125	 125	 125	 0.0	 0.0	 1	 -30.0	 30.0;
	56	 59	 0.0825	 0.251	 0.0569	 112	 112	 112	 0.0	 0.0	 1	 -30.0	 30.0;
	56	 59	 0.0803	 0.239	 0.0536	 117	 117	 117	 0.0	 0.0	 1	 -30.0	 30.0;
	55	 59	 0.04739	 0.2158	 0.05646	 133	 133	 133	 0.0	 0.0	 1	 -30.0	 30.0;
	59	 60	 0.0317	 0.145	 0.0376	 176	 176	 176	 0.0	 0.0	 1	 -30.0	 30.0;
	59	 61	 0.0328	 0.15	 0.0388	 176	 176	 176	 0.0	 0.0	 1	 -30.0	 30.0;
	60	 61	 0.00264	 0.0135	 0.01456	 186	 186	 186	 0.0	 0.0	 1	 -30.0	 30.0;
	60	 62	 0.0123	 0.0561	 0.01468	 176	 176	 176	 0.0	 0.0	 1	 -30.0	 30.0;
	61	 62	 0.00824	 0.0376	 0.0098	 176	 176	 176	 0.0	 0.0	 1	 -30.0	 30.0;
	63	 59	 0.0	 0.0386	 0.0	 760	 760	 760	 0.96	 0.0	 1	 -30.0	 30.0;
	63	 64	 0.00172	 0.02	 0.216	 687	 687	 687	 0.0	 0.0	 1	 -30.0	 30.0;
	64	 61	 0.0	 0.0268	 0.0	 1095	 1095	 1095	 0.985	 0.0	 1	 -30.0	 30.0;
	38	 65	 0.00901	 0.0986	 1.046	 297	 297	 297	 0.0	 0.0	 1	 -30.0	 30.0;
	64	 65	 0.00269	 0.0302	 0.38	 675	 675	 675	 0.0	 0.0	 1	 -30.0	 30.0;
	49	 66	 0.018	 0.0919	 0.0248	 186	 186	 186	 0.0	 0.0	 1	 -30.0	 30.0;
	49	 66	 0.018	 0.0919	 0.0248	 186	 186	 186	 0.0	 0.0	 1	 -30.0	 30.0;
	62	 66	 0.0482	 0.218	 0.0578	 132	 132	 132	 0.0	 0.0	 1	 -30.0	 30.0;
	62	 67	 0.0258	 0.117	 0.031	 176	 176	 176	 0.0	 0.0	 1	 -30.0	 30.0;
	65	 66	 0.0	 0.037	 0.0	 793	 793	 793	 0.935	 0.0	 1	 -30.0	 30.0;
	66	 67	 0.0224	 0.1015	 0.02682	 176	 176	 176	 0.0	 0.0	 1	 -30.0	 30.0;
	65	 68	 0.00138	 0.016	 0.638	 686	 686	 686	 0.0	 0.0	 1	 -30.0	 30.0;
	47	 69	 0.0844	 0.2778	 0.07092	 102	 102	 102	 0.0	 0.0	 1	 -30.0	 30.0;
	49	 69	 0.0985	 0.324	 0.0828	 87	 87	 87	 0.0	 0.0	 1	 -30.0	 30.0;
	68	 69	 0.0	 0.037	 0.0	 793	 793	 793	 0.935	 0.0	 1	 -30.0	 30.0;
	69	 70	 0.03	 0.127	 0.122	 170	 170	 170	 0.0	 0.0	 1	 -30.0	 30.0;
	24	 70	 0.00221	 0.4115	 0.10198	 72	 72	 72	 0.0	 0.0	 1	 -30.0	 30.0;
	70	 71	 0.00882	 0.0355	 0.00878	 166	 166	 166	 0.0	 0.0	 1	 -30.0	 30.0;
	24	 72	 0.0488	 0.196	 0.0488	 146	 146	 146	 0.0	 0.0	 1	 -30.0	 30.0;
	71	 72	 0.0446	 0.18	 0.04444	 159	 159	 159	 0.0	 0.0	 1	 -30.0	 30.0;
	71	 73	 0.00866	 0.0454	 0.01178	 188	 188	 188	 0.0	 0.0	 1	 -30.0	 30.0;
	70	 74	 0.0401	 0.1323	 0.03368	 151	 151	 151	 0.0	 0.0	 1	 -30.0	 30.0;
	70	 75	 0.0428	 0.141	 0.036	 151	 151	 151	 0.0	 0.0	 1	 -30.0	 30.0;
	69	 75	 0.0405	 0.122	 0.124	 145	 145	 145	 0.0	 0.0	 1	 -30.0	 30.0;
	74	 75	 0.0123	 0.0406	 0.01034	 151	 151	 151	 0.0	 0.0	 1	 -30.0	 30.0;
	76	 77	 0.0444	 0.148	 0.0368	 152	 152	 152	 0.0	 0.0	 1	 -30.0	 30.0;
	69	 77	 0.0309	 0.101	 0.1038	 150	 150	 150	 0.0	 0.0	 1	 -30.0	 30.0;
	75	 77	 0.0601	 0.1999	 0.04978	 141	 141	 141	 0.0	 0.0	 1	 -30.0	 30.0;
	77	 78	 0.00376	 0.0124	 0.01264	 151	 151	 151	 0.0	 0.0	 1	 -30.0	 30.0;
	78	 79	 0.00546	 0.0244	 0.00648	 174	 174	 174	 0.0	 0.0	 1	 -30.0	 30.0;
	77	 80	 0.017	 0.0485	 0.0472	 141	 141	 141	 0.0	 0.0	 1	 -30.0	 30.0;
	77	 80	 0.0294	 0.105	 0.0228	 157	 157	 157	 0.0	 0.0	 1	 -30.0	 30.0;
	79	 80	 0.0156	 0.0704	 0.0187	 175	 175	 175	 0.0	 0.0	 1	 -30.0	 30.0;
	68	 81	 0.00175	 0.0202	 0.808	 684	 684	 684	 0.0	 0.0	 1	 -30.0	 30.0;
	81	 80	 0.0	 0.037	 0.0	 793	 793	 793	 0.935	 0.0	 1	 -30.0	 30.0;
	77	 82	 0.0298	 0.0853	 0.08174	 141	 141	 141	 0.0	 0.0	 1	 -30.0	 30.0;
	82	 83	 0.0112	 0.03665	 0.03796	 150	 150	 150	 0.0	 0.0	 1	 -30.0	 30.0;
	83	 84	 0.0625	 0.132	 0.0258	 122	 122	 122	 0.0	 0.0	 1	 -30.0	 30.0;
	83	 85	 0.043	 0.148	 0.0348	 154	 154	 154	 0.0	 0.0	 1	 -30.0	 30.0;
	84	 85	 0.0302	 0.0641	 0.01234	 122	 122	 122	 0.0	 0.0	 1	 -30.0	 30.0;
	85	 86	 0.035	 0.123	 0.0276	 156	 156	 156	 0.0	 0.0	 1	 -30.0	 30.0;
	86	 87	 0.02828	 0.2074	 0.0445	 141	 141	 141	 1.0	 0.0	 1	 -30.0	 30.0;
	85	 88	 0.02	 0.102	 0.0276	 186	 186	 186	 0.0	 0.0	 1	 -30.0	 30.0;
	85	 89	 0.0239	 0.173	 0.047	 168	 168	 168	 0.0	 0.0	 1	 -30.0	 30.0;
	88	 89	 0.0139	 0.0712	 0.01934	 186	 186	 186	 0.0	 0.0	 1	 -30.0	 30.0;
	89	 90	 0.0518	 0.188	 0.0528	 151	 151	 151	 0.0	 0.0	 1	 -30.0	 30.0;
	89	 90	 0.0238	 0.0997	 0.106	 169	 169	 169	 0.0	 0.0	 1	 -30.0	 30.0;
	90	 91	 0.0254	 0.0836	 0.0214	 151	 151	 151	 0.0	 0.0	 1	 -30.0	 30.0;
	89	 92	 0.0099	 0.0505	 0.0548	 186	 186	 186	 0.0	 0.0	 1	 -30.0	 30.0;
	89	 92	 0.0393	 0.1581	 0.0414	 166	 166	 166	 0.0	 0.0	 1	 -30.0	 30.0;
	91	 92	 0.0387	 0.1272	 0.03268	 151	 151	 151	 0.0	 0.0	 1	 -30.0	 30.0;
	92	 93	 0.0258	 0.0848	 0.0218	 151	 151	 151	 0.0	 0.0	 1	 -30.0	 30.0;
	92	 94	 0.0481	 0.158	 0.0406	 151	 151	 151	 0.0	 0.0	 1	 -30.0	 30.0;
	93	 94	 0.0223	 0.0732	 0.01876	 151	 151	 151	 0.0	 0.0	 1	 -30.0	 30.0;
	94	 95	 0.0132	 0.0434	 0.0111	 151	 151	 151	 0.0	 0.0	 1	 -30.0	 30.0;
	80	 96	 0.0356	 0.182	 0.0494	 159	 159	 159	 0.0	 0.0	 1	 -30.0	 30.0;
	82	 96	 0.0162	 0.053	 0.0544	 150	 150	 150	 0.0	 0.0	 1	 -30.0	 30.0;
	94	 96	 0.0269	 0.0869	 0.023	 149	 149	 149	 0.0	 0.0	 1	 -30.0	 30.0;
	80	 97	 0.0183	 0.0934	 0.0254	 186	 186	 186	 0.0	 0.0	 1	 -30.0	 30.0;
	80	 98	 0.0238	 0.108	 0.0286	 176	 176	 176	 0.0	 0.0	 1	 -30.0	 30.0;
	80	 99	 0.0454	 0.206	 0.0546	 140	 140	 140	 0.0	 0.0	 1	 -30.0	 30.0;
	92	 100	 0.0648	 0.295	 0.0472	 98	 98	 98	 0.0	 0.0	 1	 -30.0	 30.0;
	94	 100	 0.0178	 0.058	 0.0604	 150	 150	 150	 0.0	 0.0	 1	 -30.0	 30.0;
	95	 96	 0.0171	 0.0547	 0.01474	 149	 149	 149	 0.0	 0.0	 1	 -30.0	 30.0;
	96	 97	 0.0173	 0.0885	 0.024	 186	 186	 186	 0.0	 0.0	 1	 -30.0	 30.0;
	98	 100	 0.0397	 0.179	 0.0476	 160	 160	 160	 0.0	 0.0	 1	 -30.0	 30.0;
	99	 100	 0.018	 0.0813	 0.0216	 175	 175	 175	 0.0	 0.0	 1	 -30.0	 30.0;
	100	 101	 0.0277	 0.1262	 0.0328	 176	 176	 176	 0.0	 0.0	 1	 -30.0	 30.0;
	92	 102	 0.0123	 0.0559	 0.01464	 176	 176	 176	 0.0	 0.0	 1	 -30.0	 30.0;
	101	 102	 0.0246	 0.112	 0.0294	 176	 176	 176	 0.0	 0.0	 1	 -30.0	 30.0;
	100	 103	 0.016	 0.0525	 0.0536	 151	 151	 151	 0.0	 0.0	 1	 -30.0	 30.0;
	100	 104	 0.0451	 0.204	 0.0541	 141	 141	 141	 0.0	 0.0	 1	 -30.0	 30.0;
	103	 104	 0.0466	 0.1584	 0.0407	 153	 153	 153	 0.0	 0.0	 1	 -30.0	 30.0;
	103	 105	 0.0535	 0.1625	 0.0408	 145	 145	 145	 0.0	 0.0	 1	 -30.0	 30.0;
	100	 106	 0.0605	 0.229	 0.062	 124	 124	 124	 0.0	 0.0	 1	 -30.0	 30.0;
	104	 105	 0.00994	 0.0378	 0.00986	 161	 161	 161	 0.0	 0.0	 1	 -30.0	 30.0;
	105	 106	 0.014	 0.0547	 0.01434	 164	 164	 164	 0.0	 0.0	 1	 -30.0	 30.0;
	105	 107	 0.053	 0.183	 0.0472	 154	 154	 154	 0.0	 0.0	 1	 -30.0	 30.0;
	105	 108	 0.0261	 0.0703	 0.01844	 137	 137	 137	 0.0	 0.0	 1	 -30.0	 30.0;
	106	 107	 0.053	 0.183	 0.0472	 154	 154	 154	 0.0	 0.0	 1	 -30.0	 30.0;
	108	 109	 0.0105	 0.0288	 0.0076	 138	 138	 138	 0.0	 0.0	 1	 -30.0	 30.0;
	103	 110	 0.03906	 0.1813	 0.0461	 159	 159	 159	 0.0	 0.0	 1	 -30.0	 30.0;
	109	 110	 0.0278	 0.0762	 0.0202	 138	 138	 138	 0.0	 0.0	 1	 -30.0	 30.0;
	110	 111	 0.022	 0.0755	 0.02	 154	 154	 154	 0.0	 0.0	 1	 -30.0	 30.0;
	110	 112	 0.0247	 0.064	 0.062	 135	 135	 135	 0.0	 0.0	 1	 -30.0	 30.0;
	17	 113	 0.00913	 0.0301	 0.00768	 151	 151	 151	 0.0	 0.0	 1	 -30.0	 30.0;
	32	 113	 0.0615	 0.203	 0.0518	 139	 139	 139	 0.0	 0.0	 1	 -30.0	 30.0;
	32	 114	 0.0135	 0.0612	 0.01628	 176	 176	 176	 0.0	 0.0	 1	 -30.0	 30.0;
	27	 115	 0.0164	 0.0741	 0.01972	 175	 175	 175	 0.0	 0.0	 1	 -30.0	 30.0;
	114	 115	 0.0023	 0.0104	 0.00276	 175	 175	 175	 0.0	 0.0	 1	 -30.0	 30.0;
	68	 116	 0.00034	 0.00405	 0.164	 7218	 7218	 7218	 1.0	 0.0	 1	 -30.0	 30.0;
	12	 117	 0.0329	 0.14	 0.0358	 170	 170	 170	 0.0	 0.0	 1	 -30.0	 30.0;
	75	 118	 0.0145	 0.0481	 0.01198	 151	 151	 151	 0.0	 0.0	 1	 -30.0	 30.0;
	76	 118	 0.0164	 0.0544	 0.01356	 151	 151	 151	 0.0	 0.0	 1	 -30.0	 30.0;
];

% INFO    : === Translation Options ===
% INFO    : Phase Angle Bound:           30.0 (deg.)
% INFO    : Line Capacity Model:         stat
% INFO    : Gen Active Capacity Model:   stat
% INFO    : Gen Reactive Capacity Model: am50ag
% INFO    : Gen Active Cost Model:       stat
% INFO    : Setting Flat Start
% INFO    : Line Capacity PAB:           15.0 (deg.)
% INFO    : 
% INFO    : === Generator Classification Notes ===
% INFO    : PEL    1   -     1.94
% INFO    : SYNC   35  -     0.00
% INFO    : COW    7   -    58.61
% INFO    : NG     11  -    39.45
% INFO    : 
% INFO    : === Generator Active Capacity Stat Model Notes ===
% INFO    : Gen at bus 1 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 4 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 6 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 8 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 10 - NG	: Pg=450.0, Pmax=550.0 -> Pmax=505   samples: 89
% INFO    : Gen at bus 12 - PEL	: Pg=85.0, Pmax=185.0 -> Pmax=85   samples: 1
% INFO    : Gen at bus 15 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 18 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 19 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 24 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 25 - NG	: Pg=220.0, Pmax=320.0 -> Pmax=221   samples: 4
% INFO    : Gen at bus 26 - COW	: Pg=314.0, Pmax=414.0 -> Pmax=485   samples: 4
% INFO    : Gen at bus 27 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 31 - COW	: Pg=7.0, Pmax=107.0 -> Pmax=17   samples: 1
% INFO    : Gen at bus 32 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 34 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 36 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 40 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 42 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 46 - NG	: Pg=19.0, Pmax=119.0 -> Pmax=20   samples: 9
% INFO    : Gen at bus 49 - NG	: Pg=204.0, Pmax=304.0 -> Pmax=223   samples: 3
% INFO    : Gen at bus 54 - NG	: Pg=48.0, Pmax=148.0 -> Pmax=53   samples: 2
% INFO    : Gen at bus 55 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 56 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 59 - NG	: Pg=155.0, Pmax=255.0 -> Pmax=308   samples: 1
% INFO    : Gen at bus 61 - NG	: Pg=160.0, Pmax=260.0 -> Pmax=195   samples: 4
% INFO    : Gen at bus 62 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% WARNING : Failed to find a generator capacity within (391.0-1955.0) after 100 samples, using percent increase model
% INFO    : Gen at bus 65 - NG	: Pg=391.0, Pmax=491.0 -> Pmax=441   samples: 100
% INFO    : Gen at bus 66 - COW	: Pg=392.0, Pmax=492.0 -> Pmax=784   samples: 1
% INFO    : Gen at bus 69 - COW	: Pg=516.4, Pmax=805.2 -> Pmax=1182   samples: 1
% INFO    : Gen at bus 70 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 72 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 73 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 74 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 76 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 77 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 80 - COW	: Pg=477.0, Pmax=577.0 -> Pmax=509   samples: 5
% INFO    : Gen at bus 85 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 87 - NG	: Pg=4.0, Pmax=104.0 -> Pmax=10   samples: 20
% INFO    : Gen at bus 89 - COW	: Pg=607.0, Pmax=707.0 -> Pmax=637   samples: 12
% INFO    : Gen at bus 90 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 91 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 92 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 99 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 100 - COW	: Pg=252.0, Pmax=352.0 -> Pmax=653   samples: 1
% INFO    : Gen at bus 103 - NG	: Pg=40.0, Pmax=140.0 -> Pmax=108   samples: 1
% INFO    : Gen at bus 104 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 105 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 107 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 110 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 111 - NG	: Pg=36.0, Pmax=136.0 -> Pmax=79   samples: 1
% INFO    : Gen at bus 112 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 113 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 116 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : 
% INFO    : === Generator Reactive Capacity Atmost Max 50 Percent Active Model Notes ===
% INFO    : Gen at bus 12 - PEL	: Pmax 85.0, Qmin -35.0, Qmax 120.0 -> Qmin -35.0, Qmax 43.0
% INFO    : Gen at bus 25 - NG	: Pmax 221.0, Qmin -47.0, Qmax 140.0 -> Qmin -47.0, Qmax 111.0
% INFO    : Gen at bus 26 - COW	: Pmax 485.0, Qmin -1000.0, Qmax 1000.0 -> Qmin -243.0, Qmax 243.0
% INFO    : Gen at bus 31 - COW	: Pmax 17.0, Qmin -300.0, Qmax 300.0 -> Qmin -9.0, Qmax 9.0
% INFO    : Gen at bus 46 - NG	: Pmax 20.0, Qmin -100.0, Qmax 100.0 -> Qmin -10.0, Qmax 10.0
% INFO    : Gen at bus 49 - NG	: Pmax 223.0, Qmin -85.0, Qmax 210.0 -> Qmin -85.0, Qmax 112.0
% INFO    : Gen at bus 54 - NG	: Pmax 53.0, Qmin -300.0, Qmax 300.0 -> Qmin -27.0, Qmax 27.0
% INFO    : Gen at bus 59 - NG	: Pmax 308.0, Qmin -60.0, Qmax 180.0 -> Qmin -60.0, Qmax 154.0
% INFO    : Gen at bus 61 - NG	: Pmax 195.0, Qmin -100.0, Qmax 300.0 -> Qmin -98.0, Qmax 98.0
% INFO    : Gen at bus 80 - COW	: Pmax 509.0, Qmin -165.0, Qmax 280.0 -> Qmin -165.0, Qmax 255.0
% INFO    : Gen at bus 87 - NG	: Pmax 10.0, Qmin -100.0, Qmax 1000.0 -> Qmin -5.0, Qmax 5.0
% INFO    : Gen at bus 111 - NG	: Pmax 79.0, Qmin -100.0, Qmax 1000.0 -> Qmin -40.0, Qmax 40.0
% INFO    : 
% INFO    : === Generator Active Cost Stat Model Notes ===
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.0222222 -> 0 24.9834202522 0
% INFO    : Updated Generator Cost: PEL - 0.0 20.0 0.117647 -> 0 124.581564277 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.0454545 -> 0 28.9483210069 0
% INFO    : Updated Generator Cost: COW - 0.0 20.0 0.0318471 -> 0 22.2209797865 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: COW - 0.0 20.0 1.42857 -> 0 25.9939815247 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.526316 -> 0 24.2023057396 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.0490196 -> 0 16.6739422708 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.208333 -> 0 27.2773428199 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.0645161 -> 0 24.861868038 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.0625 -> 0 16.0560421906 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.0255754 -> 0 34.7817782086 0
% INFO    : Updated Generator Cost: COW - 0.0 20.0 0.0255102 -> 0 32.6687805513 0
% INFO    : Updated Generator Cost: COW - 0.0 20.0 0.0193648 -> 0 25.7584423048 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: COW - 0.0 20.0 0.0209644 -> 0 24.6007721234 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 2.5 -> 0 34.0726329039 0
% INFO    : Updated Generator Cost: COW - 0.0 20.0 0.0164745 -> 0 24.6051023578 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: COW - 0.0 20.0 0.0396825 -> 0 12.6121695815 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.25 -> 0 28.6494708076 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.277778 -> 0 35.0434012722 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : 
% INFO    : === Generator Bounds Update Notes ===
% INFO    : 
% INFO    : === Base KV Replacement Notes ===
% INFO    : 
% INFO    : === Transformer Setting Replacement Notes ===
% WARNING : Branch 86-87 connects two different voltage levels (138.0, 161.0), changing tap ratio 0.0 => 1.0
% WARNING : Branch 68-116 connects two different voltage levels (345.0, 138.0), changing tap ratio 0.0 => 1.0
% INFO    : 
% INFO    : === Line Capacity Stat Model Notes ===
% INFO    : Updated Thermal Rating: on line 1-2 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 151
% INFO    : Updated Thermal Rating: on line 1-3 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 151
% INFO    : Updated Thermal Rating: on line 4-5 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 176
% INFO    : Updated Thermal Rating: on line 3-5 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 175
% INFO    : Updated Thermal Rating: on line 5-6 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 176
% INFO    : Updated Thermal Rating: on line 6-7 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 176
% INFO    : Updated Thermal Rating: on line 8-9 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 711
% WARNING : Missing data for branch flow stat model on line 8-5 using max current model : from_basekv=345.0 to_basekv=138.0 r=0.0 x=0.0267
% INFO    : Updated Thermal Rating: on transformer 8-5 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1099
% INFO    : Updated Thermal Rating: on line 9-10 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 710
% INFO    : Updated Thermal Rating: on line 4-11 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 151
% INFO    : Updated Thermal Rating: on line 5-11 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 152
% INFO    : Updated Thermal Rating: on line 11-12 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 151
% INFO    : Updated Thermal Rating: on line 2-12 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 151
% INFO    : Updated Thermal Rating: on line 3-12 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 151
% INFO    : Updated Thermal Rating: on line 7-12 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 164
% INFO    : Updated Thermal Rating: on line 11-13 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 151
% INFO    : Updated Thermal Rating: on line 12-14 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 151
% WARNING : Updated Thermal Rating Stat Model was larger than UB Model: on 13-15 : 150 , 114
% INFO    : Updated Thermal Rating: on line 13-15 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 115
% WARNING : Updated Thermal Rating Stat Model was larger than UB Model: on 14-15 : 149 , 143
% INFO    : Updated Thermal Rating: on line 14-15 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 144
% INFO    : Updated Thermal Rating: on line 12-16 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 164
% INFO    : Updated Thermal Rating: on line 15-17 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 151
% WARNING : Updated Thermal Rating Stat Model was larger than UB Model: on 16-17 : 164 , 157
% INFO    : Updated Thermal Rating: on line 16-17 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 158
% INFO    : Updated Thermal Rating: on line 17-18 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 167
% INFO    : Updated Thermal Rating: on line 18-19 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 173
% INFO    : Updated Thermal Rating: on line 19-20 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 178
% INFO    : Updated Thermal Rating: on line 15-19 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 151
% INFO    : Updated Thermal Rating: on line 20-21 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 177
% INFO    : Updated Thermal Rating: on line 21-22 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 178
% INFO    : Updated Thermal Rating: on line 22-23 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 178
% INFO    : Updated Thermal Rating: on line 23-24 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 158
% INFO    : Updated Thermal Rating: on line 23-25 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 186
% WARNING : Missing data for branch flow stat model on line 26-25 using max current model : from_basekv=345.0 to_basekv=138.0 r=0.0 x=0.0382
% INFO    : Updated Thermal Rating: on transformer 26-25 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 768
% WARNING : Updated Thermal Rating Stat Model was larger than UB Model: on 25-27 : 185 , 176
% INFO    : Updated Thermal Rating: on line 25-27 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 177
% INFO    : Updated Thermal Rating: on line 27-28 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 174
% INFO    : Updated Thermal Rating: on line 28-29 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 165
% WARNING : Missing data for branch flow stat model on line 30-17 using max current model : from_basekv=345.0 to_basekv=138.0 r=0.0 x=0.0388
% INFO    : Updated Thermal Rating: on transformer 30-17 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 756
% WARNING : Updated Thermal Rating Stat Model was larger than UB Model: on 8-30 : 687 , 579
% INFO    : Updated Thermal Rating: on line 8-30 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 580
% WARNING : Updated Thermal Rating Stat Model was larger than UB Model: on 26-30 : 661 , 339
% INFO    : Updated Thermal Rating: on line 26-30 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 340
% INFO    : Updated Thermal Rating: on line 17-31 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 151
% INFO    : Updated Thermal Rating: on line 29-31 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 146
% INFO    : Updated Thermal Rating: on line 23-32 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 158
% INFO    : Updated Thermal Rating: on line 31-32 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 151
% INFO    : Updated Thermal Rating: on line 27-32 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 151
% INFO    : Updated Thermal Rating: on line 15-33 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 150
% WARNING : Updated Thermal Rating Stat Model was larger than UB Model: on 19-34 : 150 , 113
% INFO    : Updated Thermal Rating: on line 19-34 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 114
% INFO    : Updated Thermal Rating: on line 35-36 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 176
% INFO    : Updated Thermal Rating: on line 35-37 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 175
% INFO    : Updated Thermal Rating: on line 33-37 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 154
% INFO    : Updated Thermal Rating: on line 34-36 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 146
% INFO    : Updated Thermal Rating: on line 34-37 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 159
% WARNING : Missing data for branch flow stat model on line 38-37 using max current model : from_basekv=345.0 to_basekv=138.0 r=0.0 x=0.0375
% INFO    : Updated Thermal Rating: on transformer 38-37 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 783
% INFO    : Updated Thermal Rating: on line 37-39 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 151
% INFO    : Updated Thermal Rating: on line 37-40 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 140
% WARNING : Updated Thermal Rating Stat Model was larger than UB Model: on 30-38 : 686 , 541
% INFO    : Updated Thermal Rating: on line 30-38 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 542
% INFO    : Updated Thermal Rating: on line 39-40 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 151
% INFO    : Updated Thermal Rating: on line 40-41 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 152
% INFO    : Updated Thermal Rating: on line 40-42 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 151
% INFO    : Updated Thermal Rating: on line 41-42 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 151
% WARNING : Updated Thermal Rating Stat Model was larger than UB Model: on 43-44 : 165 , 116
% INFO    : Updated Thermal Rating: on line 43-44 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 117
% INFO    : Updated Thermal Rating: on line 34-43 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 167
% INFO    : Updated Thermal Rating: on line 44-45 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 166
% INFO    : Updated Thermal Rating: on line 45-46 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 153
% INFO    : Updated Thermal Rating: on line 46-47 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 152
% INFO    : Updated Thermal Rating: on line 46-48 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 148
% INFO    : Updated Thermal Rating: on line 47-49 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 150
% WARNING : Updated Thermal Rating Stat Model was larger than UB Model: on 42-49 : 174 , 88
% INFO    : Updated Thermal Rating: on line 42-49 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 89
% WARNING : Updated Thermal Rating Stat Model was larger than UB Model: on 42-49 : 174 , 88
% INFO    : Updated Thermal Rating: on line 42-49 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 89
% INFO    : Updated Thermal Rating: on line 45-49 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 138
% INFO    : Updated Thermal Rating: on line 48-49 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 140
% INFO    : Updated Thermal Rating: on line 49-50 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 140
% INFO    : Updated Thermal Rating: on line 49-51 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 140
% INFO    : Updated Thermal Rating: on line 51-52 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 142
% INFO    : Updated Thermal Rating: on line 52-53 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 166
% INFO    : Updated Thermal Rating: on line 53-54 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 177
% WARNING : Updated Thermal Rating Stat Model was larger than UB Model: on 49-54 : 164 , 98
% INFO    : Updated Thermal Rating: on line 49-54 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 99
% WARNING : Updated Thermal Rating Stat Model was larger than UB Model: on 49-54 : 151 , 96
% INFO    : Updated Thermal Rating: on line 49-54 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 97
% INFO    : Updated Thermal Rating: on line 54-55 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 169
% INFO    : Updated Thermal Rating: on line 54-56 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 155
% INFO    : Updated Thermal Rating: on line 55-56 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 146
% INFO    : Updated Thermal Rating: on line 56-57 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 140
% INFO    : Updated Thermal Rating: on line 50-57 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 140
% INFO    : Updated Thermal Rating: on line 56-58 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 140
% INFO    : Updated Thermal Rating: on line 51-58 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 140
% WARNING : Updated Thermal Rating Stat Model was larger than UB Model: on 54-59 : 175 , 124
% INFO    : Updated Thermal Rating: on line 54-59 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 125
% WARNING : Updated Thermal Rating Stat Model was larger than UB Model: on 56-59 : 144 , 111
% INFO    : Updated Thermal Rating: on line 56-59 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 112
% WARNING : Updated Thermal Rating Stat Model was larger than UB Model: on 56-59 : 143 , 116
% INFO    : Updated Thermal Rating: on line 56-59 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 117
% WARNING : Updated Thermal Rating Stat Model was larger than UB Model: on 55-59 : 175 , 132
% INFO    : Updated Thermal Rating: on line 55-59 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 133
% INFO    : Updated Thermal Rating: on line 59-60 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 176
% INFO    : Updated Thermal Rating: on line 59-61 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 176
% INFO    : Updated Thermal Rating: on line 60-61 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 186
% INFO    : Updated Thermal Rating: on line 60-62 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 176
% INFO    : Updated Thermal Rating: on line 61-62 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 176
% WARNING : Missing data for branch flow stat model on line 63-59 using max current model : from_basekv=345.0 to_basekv=138.0 r=0.0 x=0.0386
% INFO    : Updated Thermal Rating: on transformer 63-59 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 760
% INFO    : Updated Thermal Rating: on line 63-64 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 687
% WARNING : Missing data for branch flow stat model on line 64-61 using max current model : from_basekv=345.0 to_basekv=138.0 r=0.0 x=0.0268
% INFO    : Updated Thermal Rating: on transformer 64-61 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1095
% WARNING : Updated Thermal Rating Stat Model was larger than UB Model: on 38-65 : 666 , 296
% INFO    : Updated Thermal Rating: on line 38-65 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 297
% INFO    : Updated Thermal Rating: on line 64-65 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 675
% INFO    : Updated Thermal Rating: on line 49-66 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 186
% INFO    : Updated Thermal Rating: on line 49-66 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 186
% WARNING : Updated Thermal Rating Stat Model was larger than UB Model: on 62-66 : 174 , 131
% INFO    : Updated Thermal Rating: on line 62-66 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 132
% INFO    : Updated Thermal Rating: on line 62-67 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 176
% WARNING : Missing data for branch flow stat model on line 65-66 using max current model : from_basekv=345.0 to_basekv=138.0 r=0.0 x=0.037
% INFO    : Updated Thermal Rating: on transformer 65-66 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 793
% INFO    : Updated Thermal Rating: on line 66-67 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 176
% INFO    : Updated Thermal Rating: on line 65-68 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 686
% WARNING : Updated Thermal Rating Stat Model was larger than UB Model: on 47-69 : 150 , 101
% INFO    : Updated Thermal Rating: on line 47-69 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 102
% WARNING : Updated Thermal Rating Stat Model was larger than UB Model: on 49-69 : 150 , 86
% INFO    : Updated Thermal Rating: on line 49-69 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 87
% WARNING : Missing data for branch flow stat model on line 68-69 using max current model : from_basekv=345.0 to_basekv=138.0 r=0.0 x=0.037
% INFO    : Updated Thermal Rating: on transformer 68-69 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 793
% INFO    : Updated Thermal Rating: on line 69-70 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 170
% WARNING : Updated Thermal Rating Stat Model was larger than UB Model: on 24-70 : 1030 , 71
% INFO    : Updated Thermal Rating: on line 24-70 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 72
% INFO    : Updated Thermal Rating: on line 70-71 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 166
% WARNING : Updated Thermal Rating Stat Model was larger than UB Model: on 24-72 : 165 , 145
% INFO    : Updated Thermal Rating: on line 24-72 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 146
% WARNING : Updated Thermal Rating Stat Model was larger than UB Model: on 71-72 : 165 , 158
% INFO    : Updated Thermal Rating: on line 71-72 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 159
% INFO    : Updated Thermal Rating: on line 71-73 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 188
% INFO    : Updated Thermal Rating: on line 70-74 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 151
% INFO    : Updated Thermal Rating: on line 70-75 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 151
% INFO    : Updated Thermal Rating: on line 69-75 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 145
% INFO    : Updated Thermal Rating: on line 74-75 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 151
% INFO    : Updated Thermal Rating: on line 76-77 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 152
% INFO    : Updated Thermal Rating: on line 69-77 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 150
% WARNING : Updated Thermal Rating Stat Model was larger than UB Model: on 75-77 : 151 , 140
% INFO    : Updated Thermal Rating: on line 75-77 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 141
% INFO    : Updated Thermal Rating: on line 77-78 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 151
% INFO    : Updated Thermal Rating: on line 78-79 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 174
% INFO    : Updated Thermal Rating: on line 77-80 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 141
% INFO    : Updated Thermal Rating: on line 77-80 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 157
% INFO    : Updated Thermal Rating: on line 79-80 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 175
% INFO    : Updated Thermal Rating: on line 68-81 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 684
% WARNING : Missing data for branch flow stat model on line 81-80 using max current model : from_basekv=345.0 to_basekv=138.0 r=0.0 x=0.037
% INFO    : Updated Thermal Rating: on transformer 81-80 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 793
% INFO    : Updated Thermal Rating: on line 77-82 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 141
% INFO    : Updated Thermal Rating: on line 82-83 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 150
% INFO    : Updated Thermal Rating: on line 83-84 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 122
% INFO    : Updated Thermal Rating: on line 83-85 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 154
% INFO    : Updated Thermal Rating: on line 84-85 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 122
% INFO    : Updated Thermal Rating: on line 85-86 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 156
% WARNING : Different basekv values on line 86-87, branch flow stat model using max current model : from_basekv=138.0 to_basekv=161.0 
% INFO    : Updated Thermal Rating: on transformer 86-87 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 141
% INFO    : Updated Thermal Rating: on line 85-88 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 186
% WARNING : Updated Thermal Rating Stat Model was larger than UB Model: on 85-89 : 218 , 167
% INFO    : Updated Thermal Rating: on line 85-89 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 168
% INFO    : Updated Thermal Rating: on line 88-89 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 186
% WARNING : Updated Thermal Rating Stat Model was larger than UB Model: on 89-90 : 157 , 150
% INFO    : Updated Thermal Rating: on line 89-90 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 151
% INFO    : Updated Thermal Rating: on line 89-90 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 169
% INFO    : Updated Thermal Rating: on line 90-91 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 151
% INFO    : Updated Thermal Rating: on line 89-92 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 186
% INFO    : Updated Thermal Rating: on line 89-92 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 166
% INFO    : Updated Thermal Rating: on line 91-92 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 151
% INFO    : Updated Thermal Rating: on line 92-93 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 151
% INFO    : Updated Thermal Rating: on line 92-94 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 151
% INFO    : Updated Thermal Rating: on line 93-94 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 151
% INFO    : Updated Thermal Rating: on line 94-95 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 151
% WARNING : Updated Thermal Rating Stat Model was larger than UB Model: on 80-96 : 185 , 158
% INFO    : Updated Thermal Rating: on line 80-96 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 159
% INFO    : Updated Thermal Rating: on line 82-96 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 150
% INFO    : Updated Thermal Rating: on line 94-96 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 149
% INFO    : Updated Thermal Rating: on line 80-97 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 186
% INFO    : Updated Thermal Rating: on line 80-98 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 176
% WARNING : Updated Thermal Rating Stat Model was larger than UB Model: on 80-99 : 175 , 139
% INFO    : Updated Thermal Rating: on line 80-99 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 140
% WARNING : Updated Thermal Rating Stat Model was larger than UB Model: on 92-100 : 175 , 97
% INFO    : Updated Thermal Rating: on line 92-100 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 98
% INFO    : Updated Thermal Rating: on line 94-100 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 150
% INFO    : Updated Thermal Rating: on line 95-96 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 149
% INFO    : Updated Thermal Rating: on line 96-97 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 186
% WARNING : Updated Thermal Rating Stat Model was larger than UB Model: on 98-100 : 174 , 159
% INFO    : Updated Thermal Rating: on line 98-100 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 160
% INFO    : Updated Thermal Rating: on line 99-100 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 175
% INFO    : Updated Thermal Rating: on line 100-101 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 176
% INFO    : Updated Thermal Rating: on line 92-102 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 176
% INFO    : Updated Thermal Rating: on line 101-102 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 176
% INFO    : Updated Thermal Rating: on line 100-103 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 151
% WARNING : Updated Thermal Rating Stat Model was larger than UB Model: on 100-104 : 174 , 140
% INFO    : Updated Thermal Rating: on line 100-104 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 141
% INFO    : Updated Thermal Rating: on line 103-104 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 153
% INFO    : Updated Thermal Rating: on line 103-105 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 145
% WARNING : Updated Thermal Rating Stat Model was larger than UB Model: on 100-106 : 160 , 123
% INFO    : Updated Thermal Rating: on line 100-106 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 124
% INFO    : Updated Thermal Rating: on line 104-105 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 161
% INFO    : Updated Thermal Rating: on line 105-106 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 164
% INFO    : Updated Thermal Rating: on line 105-107 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 154
% INFO    : Updated Thermal Rating: on line 105-108 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 137
% INFO    : Updated Thermal Rating: on line 106-107 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 154
% INFO    : Updated Thermal Rating: on line 108-109 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 138
% WARNING : Updated Thermal Rating Stat Model was larger than UB Model: on 103-110 : 177 , 158
% INFO    : Updated Thermal Rating: on line 103-110 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 159
% INFO    : Updated Thermal Rating: on line 109-110 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 138
% INFO    : Updated Thermal Rating: on line 110-111 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 154
% INFO    : Updated Thermal Rating: on line 110-112 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 135
% INFO    : Updated Thermal Rating: on line 17-113 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 151
% WARNING : Updated Thermal Rating Stat Model was larger than UB Model: on 32-113 : 150 , 138
% INFO    : Updated Thermal Rating: on line 32-113 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 139
% INFO    : Updated Thermal Rating: on line 32-114 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 176
% INFO    : Updated Thermal Rating: on line 27-115 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 175
% INFO    : Updated Thermal Rating: on line 114-115 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 175
% WARNING : Different basekv values on line 68-116, branch flow stat model using max current model : from_basekv=345.0 to_basekv=138.0 
% INFO    : Updated Thermal Rating: on transformer 68-116 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 7218
% INFO    : Updated Thermal Rating: on line 12-117 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 170
% INFO    : Updated Thermal Rating: on line 75-118 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 151
% INFO    : Updated Thermal Rating: on line 76-118 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 151
% INFO    : 
% INFO    : === Line Capacity Monotonicity Notes ===
% INFO    : 
% INFO    : === Voltage Setpoint Replacement Notes ===
% INFO    : Bus 1	: V=0.955, theta=10.67 -> V=1.0, theta=0.0
% INFO    : Bus 2	: V=0.971, theta=11.22 -> V=1.0, theta=0.0
% INFO    : Bus 3	: V=0.968, theta=11.56 -> V=1.0, theta=0.0
% INFO    : Bus 4	: V=0.998, theta=15.28 -> V=1.0, theta=0.0
% INFO    : Bus 5	: V=1.002, theta=15.73 -> V=1.0, theta=0.0
% INFO    : Bus 6	: V=0.99, theta=13.0 -> V=1.0, theta=0.0
% INFO    : Bus 7	: V=0.989, theta=12.56 -> V=1.0, theta=0.0
% INFO    : Bus 8	: V=1.015, theta=20.77 -> V=1.0, theta=0.0
% INFO    : Bus 9	: V=1.043, theta=28.02 -> V=1.0, theta=0.0
% INFO    : Bus 10	: V=1.05, theta=35.61 -> V=1.0, theta=0.0
% INFO    : Bus 11	: V=0.985, theta=12.72 -> V=1.0, theta=0.0
% INFO    : Bus 12	: V=0.99, theta=12.2 -> V=1.0, theta=0.0
% INFO    : Bus 13	: V=0.968, theta=11.35 -> V=1.0, theta=0.0
% INFO    : Bus 14	: V=0.984, theta=11.5 -> V=1.0, theta=0.0
% INFO    : Bus 15	: V=0.97, theta=11.23 -> V=1.0, theta=0.0
% INFO    : Bus 16	: V=0.984, theta=11.91 -> V=1.0, theta=0.0
% INFO    : Bus 17	: V=0.995, theta=13.74 -> V=1.0, theta=0.0
% INFO    : Bus 18	: V=0.973, theta=11.53 -> V=1.0, theta=0.0
% INFO    : Bus 19	: V=0.963, theta=11.05 -> V=1.0, theta=0.0
% INFO    : Bus 20	: V=0.958, theta=11.93 -> V=1.0, theta=0.0
% INFO    : Bus 21	: V=0.959, theta=13.52 -> V=1.0, theta=0.0
% INFO    : Bus 22	: V=0.97, theta=16.08 -> V=1.0, theta=0.0
% INFO    : Bus 23	: V=1.0, theta=21.0 -> V=1.0, theta=0.0
% INFO    : Bus 24	: V=0.992, theta=20.89 -> V=1.0, theta=0.0
% INFO    : Bus 25	: V=1.05, theta=27.93 -> V=1.0, theta=0.0
% INFO    : Bus 26	: V=1.015, theta=29.71 -> V=1.0, theta=0.0
% INFO    : Bus 27	: V=0.968, theta=15.35 -> V=1.0, theta=0.0
% INFO    : Bus 28	: V=0.962, theta=13.62 -> V=1.0, theta=0.0
% INFO    : Bus 29	: V=0.963, theta=12.63 -> V=1.0, theta=0.0
% INFO    : Bus 30	: V=0.968, theta=18.79 -> V=1.0, theta=0.0
% INFO    : Bus 31	: V=0.967, theta=12.75 -> V=1.0, theta=0.0
% INFO    : Bus 32	: V=0.964, theta=14.8 -> V=1.0, theta=0.0
% INFO    : Bus 33	: V=0.972, theta=10.63 -> V=1.0, theta=0.0
% INFO    : Bus 34	: V=0.986, theta=11.3 -> V=1.0, theta=0.0
% INFO    : Bus 35	: V=0.981, theta=10.87 -> V=1.0, theta=0.0
% INFO    : Bus 36	: V=0.98, theta=10.87 -> V=1.0, theta=0.0
% INFO    : Bus 37	: V=0.992, theta=11.77 -> V=1.0, theta=0.0
% INFO    : Bus 38	: V=0.962, theta=16.91 -> V=1.0, theta=0.0
% INFO    : Bus 39	: V=0.97, theta=8.41 -> V=1.0, theta=0.0
% INFO    : Bus 40	: V=0.97, theta=7.35 -> V=1.0, theta=0.0
% INFO    : Bus 41	: V=0.967, theta=6.92 -> V=1.0, theta=0.0
% INFO    : Bus 42	: V=0.985, theta=8.53 -> V=1.0, theta=0.0
% INFO    : Bus 43	: V=0.978, theta=11.28 -> V=1.0, theta=0.0
% INFO    : Bus 44	: V=0.985, theta=13.82 -> V=1.0, theta=0.0
% INFO    : Bus 45	: V=0.987, theta=15.67 -> V=1.0, theta=0.0
% INFO    : Bus 46	: V=1.005, theta=18.49 -> V=1.0, theta=0.0
% INFO    : Bus 47	: V=1.017, theta=20.73 -> V=1.0, theta=0.0
% INFO    : Bus 48	: V=1.021, theta=19.93 -> V=1.0, theta=0.0
% INFO    : Bus 49	: V=1.025, theta=20.94 -> V=1.0, theta=0.0
% INFO    : Bus 50	: V=1.001, theta=18.9 -> V=1.0, theta=0.0
% INFO    : Bus 51	: V=0.967, theta=16.28 -> V=1.0, theta=0.0
% INFO    : Bus 52	: V=0.957, theta=15.32 -> V=1.0, theta=0.0
% INFO    : Bus 53	: V=0.946, theta=14.35 -> V=1.0, theta=0.0
% INFO    : Bus 54	: V=0.955, theta=15.26 -> V=1.0, theta=0.0
% INFO    : Bus 55	: V=0.952, theta=14.97 -> V=1.0, theta=0.0
% INFO    : Bus 56	: V=0.954, theta=15.16 -> V=1.0, theta=0.0
% INFO    : Bus 57	: V=0.971, theta=16.36 -> V=1.0, theta=0.0
% INFO    : Bus 58	: V=0.959, theta=15.51 -> V=1.0, theta=0.0
% INFO    : Bus 59	: V=0.985, theta=19.37 -> V=1.0, theta=0.0
% INFO    : Bus 60	: V=0.993, theta=23.15 -> V=1.0, theta=0.0
% INFO    : Bus 61	: V=0.995, theta=24.04 -> V=1.0, theta=0.0
% INFO    : Bus 62	: V=0.998, theta=23.43 -> V=1.0, theta=0.0
% INFO    : Bus 63	: V=0.969, theta=22.75 -> V=1.0, theta=0.0
% INFO    : Bus 64	: V=0.984, theta=24.52 -> V=1.0, theta=0.0
% INFO    : Bus 65	: V=1.005, theta=27.65 -> V=1.0, theta=0.0
% INFO    : Bus 66	: V=1.05, theta=27.48 -> V=1.0, theta=0.0
% INFO    : Bus 67	: V=1.02, theta=24.84 -> V=1.0, theta=0.0
% INFO    : Bus 68	: V=1.003, theta=27.55 -> V=1.0, theta=0.0
% INFO    : Bus 69	: V=1.035, theta=30.0 -> V=1.0, theta=0.0
% INFO    : Bus 70	: V=0.984, theta=22.58 -> V=1.0, theta=0.0
% INFO    : Bus 71	: V=0.987, theta=22.15 -> V=1.0, theta=0.0
% INFO    : Bus 72	: V=0.98, theta=20.98 -> V=1.0, theta=0.0
% INFO    : Bus 73	: V=0.991, theta=21.94 -> V=1.0, theta=0.0
% INFO    : Bus 74	: V=0.958, theta=21.64 -> V=1.0, theta=0.0
% INFO    : Bus 75	: V=0.967, theta=22.91 -> V=1.0, theta=0.0
% INFO    : Bus 76	: V=0.943, theta=21.77 -> V=1.0, theta=0.0
% INFO    : Bus 77	: V=1.006, theta=26.72 -> V=1.0, theta=0.0
% INFO    : Bus 78	: V=1.003, theta=26.42 -> V=1.0, theta=0.0
% INFO    : Bus 79	: V=1.009, theta=26.72 -> V=1.0, theta=0.0
% INFO    : Bus 80	: V=1.04, theta=28.96 -> V=1.0, theta=0.0
% INFO    : Bus 81	: V=0.997, theta=28.1 -> V=1.0, theta=0.0
% INFO    : Bus 82	: V=0.989, theta=27.24 -> V=1.0, theta=0.0
% INFO    : Bus 83	: V=0.985, theta=28.42 -> V=1.0, theta=0.0
% INFO    : Bus 84	: V=0.98, theta=30.95 -> V=1.0, theta=0.0
% INFO    : Bus 85	: V=0.985, theta=32.51 -> V=1.0, theta=0.0
% INFO    : Bus 86	: V=0.987, theta=31.14 -> V=1.0, theta=0.0
% INFO    : Bus 87	: V=1.015, theta=31.4 -> V=1.0, theta=0.0
% INFO    : Bus 88	: V=0.987, theta=35.64 -> V=1.0, theta=0.0
% INFO    : Bus 89	: V=1.005, theta=39.69 -> V=1.0, theta=0.0
% INFO    : Bus 90	: V=0.985, theta=33.29 -> V=1.0, theta=0.0
% INFO    : Bus 91	: V=0.98, theta=33.31 -> V=1.0, theta=0.0
% INFO    : Bus 92	: V=0.993, theta=33.8 -> V=1.0, theta=0.0
% INFO    : Bus 93	: V=0.987, theta=30.79 -> V=1.0, theta=0.0
% INFO    : Bus 94	: V=0.991, theta=28.64 -> V=1.0, theta=0.0
% INFO    : Bus 95	: V=0.981, theta=27.67 -> V=1.0, theta=0.0
% INFO    : Bus 96	: V=0.993, theta=27.51 -> V=1.0, theta=0.0
% INFO    : Bus 97	: V=1.011, theta=27.88 -> V=1.0, theta=0.0
% INFO    : Bus 98	: V=1.024, theta=27.4 -> V=1.0, theta=0.0
% INFO    : Bus 99	: V=1.01, theta=27.04 -> V=1.0, theta=0.0
% INFO    : Bus 100	: V=1.017, theta=28.03 -> V=1.0, theta=0.0
% INFO    : Bus 101	: V=0.993, theta=29.61 -> V=1.0, theta=0.0
% INFO    : Bus 102	: V=0.991, theta=32.3 -> V=1.0, theta=0.0
% INFO    : Bus 103	: V=1.001, theta=24.44 -> V=1.0, theta=0.0
% INFO    : Bus 104	: V=0.971, theta=21.69 -> V=1.0, theta=0.0
% INFO    : Bus 105	: V=0.965, theta=20.57 -> V=1.0, theta=0.0
% INFO    : Bus 106	: V=0.962, theta=20.32 -> V=1.0, theta=0.0
% INFO    : Bus 107	: V=0.952, theta=17.53 -> V=1.0, theta=0.0
% INFO    : Bus 108	: V=0.967, theta=19.38 -> V=1.0, theta=0.0
% INFO    : Bus 109	: V=0.967, theta=18.93 -> V=1.0, theta=0.0
% INFO    : Bus 110	: V=0.973, theta=18.09 -> V=1.0, theta=0.0
% INFO    : Bus 111	: V=0.98, theta=19.74 -> V=1.0, theta=0.0
% INFO    : Bus 112	: V=0.975, theta=14.99 -> V=1.0, theta=0.0
% INFO    : Bus 113	: V=0.993, theta=13.74 -> V=1.0, theta=0.0
% INFO    : Bus 114	: V=0.96, theta=14.46 -> V=1.0, theta=0.0
% INFO    : Bus 115	: V=0.96, theta=14.46 -> V=1.0, theta=0.0
% INFO    : Bus 116	: V=1.005, theta=27.12 -> V=1.0, theta=0.0
% INFO    : Bus 117	: V=0.974, theta=10.67 -> V=1.0, theta=0.0
% INFO    : Bus 118	: V=0.949, theta=21.92 -> V=1.0, theta=0.0
% INFO    : 
% INFO    : === Generator Setpoint Replacement Notes ===
% INFO    : Gen at bus 1	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=5.0
% INFO    : Gen at bus 1	: Vg=0.955 -> Vg=1.0
% INFO    : Gen at bus 4	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=0.0
% INFO    : Gen at bus 4	: Vg=0.998 -> Vg=1.0
% INFO    : Gen at bus 6	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=18.5
% INFO    : Gen at bus 6	: Vg=0.99 -> Vg=1.0
% INFO    : Gen at bus 8	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=0.0
% INFO    : Gen at bus 8	: Vg=1.015 -> Vg=1.0
% INFO    : Gen at bus 10	: Pg=450.0, Qg=0.0 -> Pg=252.5, Qg=26.5
% INFO    : Gen at bus 10	: Vg=1.05 -> Vg=1.0
% INFO    : Gen at bus 12	: Pg=85.0, Qg=0.0 -> Pg=42.5, Qg=4.0
% INFO    : Gen at bus 12	: Vg=0.99 -> Vg=1.0
% INFO    : Gen at bus 15	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=10.0
% INFO    : Gen at bus 15	: Vg=0.97 -> Vg=1.0
% INFO    : Gen at bus 18	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=17.0
% INFO    : Gen at bus 18	: Vg=0.973 -> Vg=1.0
% INFO    : Gen at bus 19	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=8.0
% INFO    : Gen at bus 19	: Vg=0.962 -> Vg=1.0
% INFO    : Gen at bus 24	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=0.0
% INFO    : Gen at bus 24	: Vg=0.992 -> Vg=1.0
% INFO    : Gen at bus 25	: Pg=220.0, Qg=0.0 -> Pg=110.5, Qg=32.0
% INFO    : Gen at bus 25	: Vg=1.05 -> Vg=1.0
% INFO    : Gen at bus 26	: Pg=314.0, Qg=0.0 -> Pg=242.5, Qg=0.0
% INFO    : Gen at bus 26	: Vg=1.015 -> Vg=1.0
% INFO    : Gen at bus 27	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=0.0
% INFO    : Gen at bus 27	: Vg=0.968 -> Vg=1.0
% INFO    : Gen at bus 31	: Pg=7.0, Qg=0.0 -> Pg=8.5, Qg=0.0
% INFO    : Gen at bus 31	: Vg=0.967 -> Vg=1.0
% INFO    : Gen at bus 32	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=14.0
% INFO    : Gen at bus 32	: Vg=0.963 -> Vg=1.0
% INFO    : Gen at bus 34	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=8.0
% INFO    : Gen at bus 34	: Vg=0.984 -> Vg=1.0
% INFO    : Gen at bus 36	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=8.0
% INFO    : Gen at bus 36	: Vg=0.98 -> Vg=1.0
% INFO    : Gen at bus 40	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=0.0
% INFO    : Gen at bus 40	: Vg=0.97 -> Vg=1.0
% INFO    : Gen at bus 42	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=0.0
% INFO    : Gen at bus 42	: Vg=0.985 -> Vg=1.0
% INFO    : Gen at bus 46	: Pg=19.0, Qg=0.0 -> Pg=10.0, Qg=0.0
% INFO    : Gen at bus 46	: Vg=1.005 -> Vg=1.0
% INFO    : Gen at bus 49	: Pg=204.0, Qg=0.0 -> Pg=111.5, Qg=13.5
% INFO    : Gen at bus 49	: Vg=1.025 -> Vg=1.0
% INFO    : Gen at bus 54	: Pg=48.0, Qg=0.0 -> Pg=26.5, Qg=0.0
% INFO    : Gen at bus 54	: Vg=0.955 -> Vg=1.0
% INFO    : Gen at bus 55	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=7.5
% INFO    : Gen at bus 55	: Vg=0.952 -> Vg=1.0
% INFO    : Gen at bus 56	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=3.5
% INFO    : Gen at bus 56	: Vg=0.954 -> Vg=1.0
% INFO    : Gen at bus 59	: Pg=155.0, Qg=0.0 -> Pg=154.0, Qg=47.0
% INFO    : Gen at bus 59	: Vg=0.985 -> Vg=1.0
% INFO    : Gen at bus 61	: Pg=160.0, Qg=0.0 -> Pg=97.5, Qg=0.0
% INFO    : Gen at bus 61	: Vg=0.995 -> Vg=1.0
% INFO    : Gen at bus 62	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=0.0
% INFO    : Gen at bus 62	: Vg=0.998 -> Vg=1.0
% INFO    : Gen at bus 65	: Pg=391.0, Qg=0.0 -> Pg=220.5, Qg=66.5
% INFO    : Gen at bus 65	: Vg=1.005 -> Vg=1.0
% INFO    : Gen at bus 66	: Pg=392.0, Qg=0.0 -> Pg=392.0, Qg=66.5
% INFO    : Gen at bus 66	: Vg=1.05 -> Vg=1.0
% INFO    : Gen at bus 69	: Pg=516.4, Qg=0.0 -> Pg=591.0, Qg=0.0
% INFO    : Gen at bus 69	: Vg=1.035 -> Vg=1.0
% INFO    : Gen at bus 70	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=11.0
% INFO    : Gen at bus 70	: Vg=0.984 -> Vg=1.0
% INFO    : Gen at bus 72	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=0.0
% INFO    : Gen at bus 72	: Vg=0.98 -> Vg=1.0
% INFO    : Gen at bus 73	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=0.0
% INFO    : Gen at bus 73	: Vg=0.991 -> Vg=1.0
% INFO    : Gen at bus 74	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=1.5
% INFO    : Gen at bus 74	: Vg=0.958 -> Vg=1.0
% INFO    : Gen at bus 76	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=7.5
% INFO    : Gen at bus 76	: Vg=0.943 -> Vg=1.0
% INFO    : Gen at bus 77	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=25.0
% INFO    : Gen at bus 77	: Vg=1.006 -> Vg=1.0
% INFO    : Gen at bus 80	: Pg=477.0, Qg=0.0 -> Pg=254.5, Qg=45.0
% INFO    : Gen at bus 80	: Vg=1.04 -> Vg=1.0
% INFO    : Gen at bus 85	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=7.5
% INFO    : Gen at bus 85	: Vg=0.985 -> Vg=1.0
% INFO    : Gen at bus 87	: Pg=4.0, Qg=0.0 -> Pg=5.0, Qg=0.0
% INFO    : Gen at bus 87	: Vg=1.015 -> Vg=1.0
% INFO    : Gen at bus 89	: Pg=607.0, Qg=0.0 -> Pg=318.5, Qg=45.0
% INFO    : Gen at bus 89	: Vg=1.005 -> Vg=1.0
% INFO    : Gen at bus 90	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=0.0
% INFO    : Gen at bus 90	: Vg=0.985 -> Vg=1.0
% INFO    : Gen at bus 91	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=0.0
% INFO    : Gen at bus 91	: Vg=0.98 -> Vg=1.0
% INFO    : Gen at bus 92	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=3.0
% INFO    : Gen at bus 92	: Vg=0.99 -> Vg=1.0
% INFO    : Gen at bus 99	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=0.0
% INFO    : Gen at bus 99	: Vg=1.01 -> Vg=1.0
% INFO    : Gen at bus 100	: Pg=252.0, Qg=0.0 -> Pg=326.5, Qg=52.5
% INFO    : Gen at bus 100	: Vg=1.017 -> Vg=1.0
% INFO    : Gen at bus 103	: Pg=40.0, Qg=0.0 -> Pg=54.0, Qg=12.5
% INFO    : Gen at bus 103	: Vg=1.01 -> Vg=1.0
% INFO    : Gen at bus 104	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=7.5
% INFO    : Gen at bus 104	: Vg=0.971 -> Vg=1.0
% INFO    : Gen at bus 105	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=7.5
% INFO    : Gen at bus 105	: Vg=0.965 -> Vg=1.0
% INFO    : Gen at bus 107	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=0.0
% INFO    : Gen at bus 107	: Vg=0.952 -> Vg=1.0
% INFO    : Gen at bus 110	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=7.5
% INFO    : Gen at bus 110	: Vg=0.973 -> Vg=1.0
% INFO    : Gen at bus 111	: Pg=36.0, Qg=0.0 -> Pg=39.5, Qg=0.0
% INFO    : Gen at bus 111	: Vg=0.98 -> Vg=1.0
% INFO    : Gen at bus 112	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=450.0
% INFO    : Gen at bus 112	: Vg=0.975 -> Vg=1.0
% INFO    : Gen at bus 113	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=50.0
% INFO    : Gen at bus 113	: Vg=0.993 -> Vg=1.0
% INFO    : Gen at bus 116	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=0.0
% INFO    : Gen at bus 116	: Vg=1.005 -> Vg=1.0
% INFO    : 
% INFO    : === Writing Matpower Case File Notes ===
