import pandas as pd
import matplotlib.pyplot as plt
import os

def calc_avg_gen_time(csv_file, batch_size=20):
    df = pd.read_csv(csv_file)
    # Calculate average generation time per batch
    gen_times = df["gen_time"].values
    avg_time = gen_times.mean() / batch_size
    print(f"{os.path.basename(csv_file)} - Average generation time: {avg_time:.4f} seconds/sample")

 # Example usage
if __name__ == "__main__":
    import argparse
    parser = argparse.ArgumentParser(description="calculate average generation time from CSV file")
    parser.add_argument("--csv_file", type=str, required=True, help="path to input CSV file")
    parser.add_argument("--batch_size", type=int, default=20, help="batch size used during generation")
    args = parser.parse_args()
    calc_avg_gen_time(args.csv_file, args.batch_size)