import csv
from collections import defaultdict

def print_final_statistics_from_csv(csv_file):
    total = 0
    successful = 0
    failed = 0
    errors = 0
    class_stats = defaultdict(lambda: {'total': 0, 'success': 0, 'failed': 0})

    with open(csv_file, 'r', encoding='utf-8') as f:
        lines = f.readlines()
        f.seek(0)
        reader = csv.DictReader(lines)
        for row in reader:
            total += 1
            classname = row['classname']
            result = row['successful']
            class_stats[classname]['total'] += 1
            if result == 'success':
                successful += 1
                class_stats[classname]['success'] += 1
            elif result == 'failed':
                failed += 1
                class_stats[classname]['failed'] += 1
            else:
                errors += 1

    print(f"\n=== Final Attack Statistics ===")
    print(f"Total samples: {total}")
    print(f"Successful attacks: {successful} ({successful/total*100:.2f}%)")
    print(f"Failed attacks: {failed} ({failed/total*100:.2f}%)")
    if errors > 0:
        print(f"Errors: {errors} ({errors/total*100:.2f}%)")
    if total > errors:
        print(f"Overall success rate: {successful/(total-errors)*100:.2f}%")
    else:
        print(f"Overall success rate: 0.00%")

if __name__ == "__main__":
    import sys
    if len(sys.argv) != 2:
        print("Usage: python print_stat.py <csv_file>")
        sys.exit(1)

    csv_path = sys.argv[1]
    print_final_statistics_from_csv(csv_path)
