# Copyright (c) Facebook, Inc. and its affiliates. All Rights Reserved.
import logging
import os

logger_initialized = {}

def get_logger(name, save_dir, distributed_rank, filename="log.log", resume=False):
    logger = logging.getLogger(name)
    if name in logger_initialized:
        return logger

    logger.propagate = False
    # don't log results for the non-master process
    if distributed_rank > 0:
        logger.setLevel(logging.ERROR)
        logger.setLevel(logging.WARNING)
        return logger
    formatter = logging.Formatter("%(asctime)s %(name)s %(levelname)s: %(message)s")

    ch = logging.StreamHandler()
    ch.setLevel(logging.INFO)
    ch.setFormatter(formatter)
    logger.addHandler(ch)

    if save_dir:
        if resume:
            fh = logging.FileHandler(os.path.join(save_dir, filename), mode='a')
        else:
            fh = logging.FileHandler(os.path.join(save_dir, filename), mode='w')
        fh.setLevel(logging.INFO)
        fh.setFormatter(formatter)
        logger.addHandler(fh)

    logger.setLevel(logging.INFO)

    logger_initialized[name] = True

    return logger
