from torch import nn


class Residual(nn.Module):
    def __init__(self, module: nn.Module):
        super().__init__()
        self.module = module

    def forward(self, inputs):
        return inputs + self.module(inputs)


class Sequential(nn.Module):
    def __init__(self, *layers):
        super().__init__()
        self.layers = nn.ModuleList(layers)

    def forward(self, *inputs):
        outputs = inputs
        for layer in self.layers:
            if isinstance(outputs, (tuple, list)):
                outputs = layer(*outputs)
            else:
                outputs = layer(outputs)
        return outputs
