# Temporal Task Planner

[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)
<!-- 
[Overleaf paper](https://www.overleaf.com/project/620c2351882bb09c7ede64ff) -->

## Setup

### 1. Create conda environment
```bash
conda env create -f environment.yml
```
### 2. Activate conda environment 
- using https://direnv.net/ ...
```bash 
direnv allow
```
- or manually  activate
```bash 
conda activate temporal_task_planner
```
### 3. Install [PyTorch](https://pytorch.org/) according to your system requirements.
For example: MacOS installation, cpu only
```bash 
# MacOS Conda binaries are for x86_64 only, for M1 please use wheels
conda install pytorch -c pytorch
```

### 4. Init submodules 
```bash
git submodule update --init --recursive
```

### 5. Build custom habitat-sim
If you are installing habitat-sim for the first time, you might need some additional libraries.
Follow instructions from [habitat_sim: BUILD_FROM_SOURCE](https://github.com/XXX-1research/habitat-sim/blob/main/BUILD_FROM_SOURCE.md).
```bash 
cd third_party/habitat-sim
./build.sh --bullet --with-cuda --headless  # this might take a while...
cd -
```

### 6. Install temporal_task_planner
```bash 
pip install -e . 
```

### 7. [Optional for sweeps on cluster] Install hydra/launcher submitit slurm 
```bash
pip install hydra-submitit-launcher --upgrade
```

### 8. Add habitat-sim to your python path
```bash
export PYTHONPATH=:$PWD/third_party/habitat-sim
echo $PYTHONPATH
```

### 9. [Optional if using cuda] Set the CUBLAS CONFIG for fixed seed
```bash
export CUBLAS_WORKSPACE_CONFIG=:4096:8
```
--

## Data 
### 1. Kitchen assets
We use selected objects from the ReplicaCAD \cite{szot2021habitat} dataset, including seven types of dishes (cups, glasses, trays, small bowls, big bowls, small plates, big plates) which are loaded into the dishwasher (Fig. [Figure showing dishwaser loading ](figures/dishwasher_sim_sample.png).

The dataset will be released with the code. For example of the dataset, check folder `expert_videos` and `trained_policy_videos/`.  
### 2. Pre-generated Demonstrations 
Session jsons can be downloaded from wandb
```bash 
python scripts/data_download.py
```
This creates `artifacts/` folder containing 
`full-view-single-pref:latest` and `partial-view-single-pref:latest` datasets, where each contains train, val and test jsons.

<!-- *Note*: Some of the sample videos can be downloaded from folder `expert_videos` and `trained_policy_videos`. -->

---

## Run 
All the files in `scripts/` folder can be run as 
```
python scripts/<filename>.py
```
 Scripts 1-3 are dependent on hydra yaml config files.

#### 0. To download data: 
```python scripts/data_download.py```

This downloads the latest single preference data for full, partial visibility and multiple preferences demo scenarios.

#### 1. To rollout expert policy: 
```python scripts/rollout_batch.py ```

You need to provide config parameters like `dirpath, session_id_start, session_id_end` to `config/rollout.yaml`

#### 2. To generate session videos: 
```python scripts/view_batch.py``` 

You need to provide config parameters like `dirpath, session_id_start, session_id_end` to `config/view.yaml`.

#### 3. To train the model: 
```python scripts/prompt_situation_learner.py -m wandb.project="main" session_split_filepath="session_split_filepaths/main/num_pref-7_num_obj-6-7_num_demo-full"```

You need to provide config parameters like `pick_only, context_history, data_name, data_version` to `prompt_situation_learner.yaml`.

#### 4. To evaluate the model with rollouts
```python scripts/evaluator.py -m wandb.project="main" session_split_filepath="session_split_filepaths/main/num_pref-7_num_obj-6-7_num_demo-full" test_split_filepath="session_split_filepaths/main/num_pref-7_num_obj-6-7_num_demo-full","session_split_filepaths/main/eval_num_pref-7_num_obj-3-4-5-8-9-10_num_demo-10","session_split_filepaths/main/eval_num_pref-5_num_obj-6-7_num_demo-10","session_split_filepaths/main/eval_num_pref-5_num_obj-3-4-5-8-9-10_num_demo-10" max_test_evals=10 seed=20007```

The policy checkpoint at `multirun/{wandb.project}/seed-{seed}/best_pickplace_TP.pt` is loaded and evaluated with all possible pairs of sessions in the `test` of test_split_filepath(s). Other config parameters can changed in `config/evaluator.yaml`.

#### 5. Ablations for instance encoder
`python scripts/prompt_situation_learner_ablation_attributes.py` (modify `config/prompt_situation_learner_ablation_attributes.yaml`)
