
num_proj=2
hidden_dim=256
alpha=0.01
for dataset in piqa xsum
do
    output_dir="outputs/kv_proj_rt/${dataset}/np=${num_proj}.hd=${hidden_dim}.alpha=${alpha}/Qwen3-4B"
    mkdir -p $output_dir
    deepspeed train_kvproj.py --base_model Qwen/Qwen3-4B --dataset $dataset --output_dir $output_dir \
    --num_train_epochs 10 --learning_rate 5e-4 --num_proj $num_proj --hidden_dim $hidden_dim --alpha $alpha --per_device_train_batch_size 8 \
    --gradient_accumulation_steps 1 > $output_dir/log.txt 2>&1
done


num_proj=2
hidden_dim=256
alpha=0.01
ratio=0.95
for dataset in piqa xsum
do
    output_dir="outputs/kv_proj_ft/${dataset}/np=${num_proj}.hd=${hidden_dim}.alpha=${alpha}.r=${ratio}/Qwen2.5-3B-Instruct"
    mkdir -p $output_dir
    deepspeed train_kvproj_ft.py --base_model "./outputs/kv_proj_rt/${dataset}/np=${num_proj}.hd=${hidden_dim}.alpha=${alpha}/Qwen3-4B" \
    --dataset $dataset --output_dir $output_dir --ratio $ratio --per_device_train_batch_size 8 \
    --num_train_epochs 3 --learning_rate 5e-4 --alpha 1.0 > $output_dir/log.txt 2>&1
done