sample_schema = {
    "type": "object",
    "properties": {
        "input": {"type": "string"},
        "reasoning": {"type": "string"},
        "speech": {"type": "boolean"},
        "n_elements": {"type": "number"},
        "instruction": {"type": "string"},
        "type": {
            "type": "string",
            "enum": ["add", "replace", "remove", "other"]
        },
        "output": {"type": "string"},
        "input_neg": {"type": "string"},
        "output_neg": {"type": "string"},
    },
    "required": ["input", "reasoning", "speech", "n_elements", "instruction", "type", "output", "input_neg", "output_neg"],
    "additionalProperties": False
}

response_schema = {
    "type": "object",
    "properties": {
        "samples": {
            "type": "array",
            "items": sample_schema
        },

    },
    "required": ["samples"],
    "additionalProperties": False
}

file_schema = {
    "type": "object",
    "properties": {
        "data": sample_schema,
        "metadata": {
            "type": "object"
        },
         "additionalProperties": False
    }
}