import typing as t

import torch


class InputCaption(t.TypedDict):
    caption: str
    metadata: dict


class Candidate(t.TypedDict):
    seed: int
    guidance: float


class ModelWrapper:
    def __init__(self, device: str):
        self.device = device
        self.sample_rate = None

    def set_p2p_prop(self, attn_inject_frac: float, attn_inject_delay: float, attn_reweighting: float = 1):
        pass

    def generate_edited_audio(self, input_caption: str, output_caption: str, seed: int, cfg_scale: float, steps: int, negative_output_caption: str, **kwargs) -> torch.Tensor:
        pass

    def generate_audio(self, conditioning: list, negative_conditioning: list, seed: int, cfg_scale: float, steps: int):
        pass

class EditModelWrapper:
    def __init__(self, device: str):
        self.device = device
        self.sample_rate = None

    def edit_audio(self, **kwargs):
        pass