import json
import os
import random


def shuffle_few_shots(few_shots: list) -> list:
    random.seed(42)
    few_shots = random.sample(few_shots, len(few_shots))
    return few_shots


# Audio Prompts
base_path = os.path.dirname(__file__)
with open(os.path.join(base_path, "audio_prompt.md")) as file:
    system_prompt_audio = file.read().strip()
with open(os.path.join(base_path, "audio_prompt_few_shots.json")) as json_file:
    few_shots_audio = shuffle_few_shots(json.load(json_file))