export PYTHONPATH=$PYTHONPATH:$(pwd)

MODEL_FLAGS="--attention_resolutions 32,16,8 --class_cond False --diffusion_steps 1000 --image_size 256 --learn_sigma True --noise_schedule linear --num_channels 256 --num_head_channels 64 --num_res_blocks 2 --resblock_updown True --use_fp16 True --use_scale_shift_norm True"

CUDA_VISIBLE_DEVICES=$1 python image_adapt/scripts/image_sample_select.py $MODEL_FLAGS \
                            --batch_size 1 --num_samples 333 --timestep_respacing 100 \
                            --model_path guided_diffusion_models/256x256_diffusion_uncond.pt --base_samples imagenet_test/ \
                            --D 4 --N 50 --scale 1\
                            --corruption $2 --severity 5 \
                            --save_dir  dataset/imagenet_select --source $2