# 🧬**MARWA (Bioinformatics Workflow Assistant)**🧬

The **MARWA (Bioinformatics Workflow Assistant)** is an automated, LLM-based system designed to streamline bioinformatics workflows. By breaking down user questions, selecting appropriate tools, generating commands, and executing workflows, MARWA aims to simplify bioinformatics analysis, making it more efficient and error-free.

## **Overview**

![main](.\icon\main_01.png)

The MARWA system consists of six cooperative expert agents: **Analyzing, Planning, Selecting, Generating & Executing, Debugging, and Judging**. These agents work together in a closed-loop pipeline to help automate the workflow from start to finish. The system is further enhanced by two auxiliary components:

1. **Tool Retrieval Module**: Provides reference information on bioinformatics tools.

2. **File System Interface**: Allows the system to interact with actual file structures in the execution environment.

## **Setup & Usage**

1. **Install Dependencies**

Ensure Python>= 3.10 is installed, and then install necessary dependencies:

```bash 
pip install -r requirements.txt
```

2. **File Independence**
    - **Configure LLM API Key**: Before running the application, you need to configure the LLM API key. This can be done by setting the `LLM_API_KEY` environment variable. For example:
      ```bash
      export LLM_API_KEY=your_api_key_here
      ```
    - **Adjust File Location**: If you need to change the file locations, you can do so by modifying the file parameters in the `main.py` file.

3. **Run the Application**

After the installation, you can start the application by running the following command:

```bash
python main.py
```
This will start the web interface, and you can open it in your browser at http://localhost:7861
```command
* Running on http://127.0.0.1:7861
* Press CTRL+C to quit
```

![main](.\icon\main.png)