from langchain_core.prompts import ChatPromptTemplate
from langchain_openai import ChatOpenAI
from pydantic import BaseModel,Field
from typing import Optional, List, Union, Dict, Any
import json
import os
import time
from transformers import AutoModelForCausalLM, AutoTokenizer, pipeline
from langchain_core.output_parsers import PydanticOutputParser
import re

class JudgerTask(BaseModel):
    Complete: bool = Field(description="Whether the workflow has been fully completed")

prompt ='''
You are a bioinformatics workflow expert.  
Your task is to determine whether the given workflow has been fully completed.  

Context:  
- Workflow detailed requirement: {workflow_requirement}  
- Workflow input format requirement: {workflow_input_format}  
- Workflow output format requirement: {workflow_output_format}  
- Tools already used in the workflow (JSON array of objects with toolname and description):  
{used_tools_list}  
- Current output files:  
{available_output_files}  

Rules:  
1. The workflow is considered **complete** only if BOTH conditions are met:  
   a) The current available output files {available_output_files} include **all** required files and formats specified in {workflow_output_format}.  
   b) The workflow requirement {workflow_requirement} has been fully satisfied by the tools listed in {used_tools_list}, meaning every required analysis/processing step is covered without omission.  

2. If **any** required output is missing OR any workflow step is not accounted for by the tools used, the workflow is **not complete**.  
3. The output format must be as :{format_instructions}
Question: Has the workflow been fully completed?  
'''

class JudgerAgent:
    def __init__(self, temperature):
        self.parser = PydanticOutputParser(pydantic_object=JudgerTask)
        self.prompt = ChatPromptTemplate.from_messages([
            ("system", prompt)
        ])
        from langchain_openai import ChatOpenAI

        self.llm = ChatOpenAI(
            base_url="",
            api_key="",
            model="",
            temperature=0.3
        )

    def judge(self,workflow_requirement,workflow_input_format,workflow_output_format,used_tools_list,available_output_files):
        chain = self.prompt | self.llm | self.parser
        try:
            result = chain.invoke({"workflow_requirement": workflow_requirement, "workflow_input_format":workflow_input_format, "workflow_output_format":workflow_output_format, "used_tools_list": used_tools_list, "available_output_files": available_output_files, "format_instructions": self.parser.get_format_instructions()})
            return result
        except Exception as e:
            print(e)
            return None

def judge(workflow_requirement,workflow_input_format,workflow_output_format,used_tools_list,available_output_files):
    judger_agent = JudgerAgent()
    result = judger_agent.judge(workflow_requirement,workflow_input_format,workflow_output_format,used_tools_list,available_output_files)
    if result is None:
        return None
    else:
        return result.model_dump()["Complete"]
