

"""Groups of problems of different types for optimizer training."""

from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

import numpy as np
import tensorflow as tf

from problems import datasets
from problems import model_adapter
from problems import problem_generator as pg
from problems import problem_spec

_Spec = problem_spec.Spec

mnist_config = {
    'A': [16, 'M', 32, 'M'],
}


def mnist_conv_problems():
  return [
      # (_Spec(pg.ConvNet, ((1, 28, 28), 10, [(3, 3, 8), (5, 5, 8)]),
      #        {"activation": tf.nn.sigmoid}), datasets.mnist(train=True), 64),
      (_Spec(pg.ConvNet, ((1, 28, 28), 10, [(3, 3, 8), (5, 5, 8)]),
             {"activation": tf.nn.relu}), datasets.mnist(train=True), 64)
  ]


def cifar10_conv_problems():
  return [
      # (_Spec(pg.ConvNet, ((1, 28, 28), 10, [(3, 3, 8), (5, 5, 8)]),
      #        {"activation": tf.nn.sigmoid}), datasets.mnist(train=True), 64),
      (_Spec(pg.ConvNet, ((3, 32, 32), 10, [(3, 3, 16), (5, 5, 16)]),
             {"activation": tf.nn.relu}), 'cifar10', 64)
  ]

def test_mnist_conv_problems():
  return [
      (_Spec(pg.ConvNet, ((1, 28, 28), 10, [(3, 3, 16, 1), (5, 5, 32, 1)]),
             {"activation": tf.nn.relu}), 'mnist', 128)
  ]

def test_mnist_conv_large_problems():
  return [
      (_Spec(pg.ConvNet, ((1, 28, 28), 10, [(3, 3, 32, 1), (3, 3, 32, 1), (5, 5, 32, 1), (5, 5, 32, 1)]),
             {"activation": tf.nn.relu}), 'mnist', 128)
  ]



def test_mnist_mlp_relu_problems():
  tp = [
      (_Spec(pg.FullyConnected, (784, 10),
             {"hidden_sizes": (20,), "activation": tf.nn.relu}),
       'mnist', 128)
  ]
  return tp



def test_cifar10_conv_problems():
  return [
      (_Spec(pg.ConvNet, ((3, 32, 32), 10, [(3, 3, 16, 2), (5, 5, 32, 2)]),
             {"activation": tf.nn.relu}), 'cifar10', 128)
  ]

