
"""Groups of problems of different types for optimizer training."""

from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

import numpy as np
import tensorflow as tf

from problems import datasets
from problems import model_adapter
from problems import problem_generator as pg
from problems import problem_spec

_Spec = problem_spec.Spec



def mnist_conv_problems():
  return [
      # (_Spec(pg.ConvNet, ((1, 28, 28), 10, [(3, 3, 8), (5, 5, 8)]),
      #        {"activation": tf.nn.sigmoid}), datasets.mnist(train=True), 64),
      (_Spec(pg.ConvNet, ((1, 28, 28), 10, [(3, 3, 8), (5, 5, 8)]),
             {"activation": tf.nn.relu}), datasets.mnist(train=True), 64)
  ]

def cifar10_conv_problems():
  return [
      # (_Spec(pg.ConvNet, ((1, 28, 28), 10, [(3, 3, 8), (5, 5, 8)]),
      #        {"activation": tf.nn.sigmoid}), datasets.mnist(train=True), 64),
      (_Spec(pg.ConvNet, ((3, 32, 32), 10, [(3, 3, 16), (5, 5, 16)]),
             {"activation": tf.nn.relu}), datasets.cifar10(train=True), 128)
  ]

# MODIFY
def mnist_mlp_problems():
  tp = [
      (_Spec(pg.FullyConnected, (784, 10),
             {"hidden_sizes": (20,), "activation": tf.nn.sigmoid}),
       datasets.mnist(train=True), 128)
  ]
  return tp

