
### Environment

* Bazel ([install](https://bazel.build/versions/master/docs/install.html))
* TensorFlow >= v1.3

### Experiments on L2O-Scale

* download MNIST dataset from https://storage.googleapis.com/tensorflow/tf-keras-datasets/mnist.npz and put it into the mnist folder in L2O-Scale-Training and L2O-Scale-Evaluation
* download CIFAR-10 dataset from https://www.cs.toronto.edu/~kriz/cifar-10-python.tar.gz and put the unzipped files(data_batch_1 ....) into the cifar10 folder of L2O-Scale-Evaluation 

#### Train L2O-Scale

```shell
cd L2O-Scale-Training

python metarun.py --train_dir=dir_to_save_optimizer --regularize_time=none --alpha=5e-5 --reg_optimizer=False --reg_option=None --include_mnist_conv_problems --num_problems=1 --num_meta_iterations=100 --fix_unroll=True --fix_unroll_length=20 --evaluation_period=1 --evaluation_epochs=5 --use_second_derivatives=False --if_cl=False --if_mt=False --mt_ratio=0.1 --mt_k=1
```

#### Train L2O-Scale + Hessian Regularization

```shell
cd L2O-Scale-Training

python metarun.py --train_dir=dir_to_save_optimizer --regularize_time=none --alpha=5e-5 --reg_optimizer=True --reg_option=hessian --include_mnist_conv_problems --num_problems=1 --num_meta_iterations=100 --fix_unroll=True --fix_unroll_length=20 --evaluation_period=1 --evaluation_epochs=5 --use_second_derivatives=False --if_cl=False --if_mt=False --mt_ratio=0.1 --mt_k=1
```

#### Evaluation with L2O-Scale

```shell
cd L2O-Scale-Evaluation

python metatest.py --train_dir=dir_of_saved_optimizer --save_dir=dir_to_save_result --include_mnist_mlp_relu_problems --model_name=mnist-relu --restore_model_name=model.ckpt-0 --num_testing_itrs=10000
```

Remarks.

- You can modify --model_name and --include_mnist_conv_problems --include_cifar10_conv_problems --include_mnist_conv_large_problems for different problems
- You can change --reg_option=hessian-ev, --reg_option=jacob to use different hessian regularization
- You can change --restore_model_name to evaluate different checkpoints of the saved optimizer
