# PyTorch Implementation of our attack experiments

This repository contains the PyTorch implementation of [Paper Name], along with scripts and instructions to reproduce the experiments mentioned in the paper.

## Data
For the dataset used in the paper, the code itself will download the dataset automatically from the Hugging Face Datasets library. No manual download is required.

## Requirements
```bash
pip install -r requirements.txt

cd /TextAttack
pip install -e .
```
## Experiment Commands

For all experiment commands, refer to `run_train.sh`.

### Example 1: Running `vanilla` ICL on `rte` Dataset with Textfooler Attack

```bash
CUDA_VISIBLE_DEVICES=0 nohup bash scripts/icl/attack.sh rte meta-llama/Llama-2-7b-hf icl textfooler > ./logs/run_icl_rte_textfooler.log 2>&1 &
```

### Example 2: Running knn-icl on sst2 Dataset with Swap Labels Attack

```bash
CUDA_VISIBLE_DEVICES=0 nohup bash scripts/icl/attack.sh rte meta-llama/Llama-2-7b-hf icl textfooler > ./logs/run_icl_rte_textfooler.log 2>&1 &
```



