import sys
import cmath
import math as math
import scipy.integrate as integrate
from scipy.special import zeta, polygamma, factorial

import matplotlib.pyplot as plt
import matplotlib as mpl

import numpy as np
from my_kernel import *
from dpp_sampler import *
from utils import *
from functional_tools import *






####################################################   
################### The settings ################### 
####################################################

N_exp = 1000 # The number of experiments for a given cardinality
n_list = [5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,30,40,50,60,70,80,90,100] # The list of cardinalities
kernel_order = 3 # The order of the kernel

####################################################
####################################################  
####################################################



####################################################
############### Kernel settings ####################
####################################################

d = 1
my_kernel = Bernoulli_Kernel_Function(kernel_order,0)

pSobolev_trunc_order = 250
pSobolev_sigma_list = get_Sobolev_spectrum(kernel_order,pSobolev_trunc_order)

onb_list = []
for i in list(range(pSobolev_trunc_order)):
    onb_list.append(Fourier_Element(i))

ones_list = [1]*pSobolev_trunc_order
multi_indices = list(product(range(pSobolev_trunc_order), repeat=d))

####################################################
####################################################  
####################################################



####################################################
#################### The functions #################
####################################################

g_list = [[1],[0,0,0,0,0,0,0,0,0,1],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1]]


list_of_functions = []
list_of_norms = []

for m in list(range(3)):
    normalized_coefficents = []
    for i in list(range(len(g_list[m]))):
        normalized_coefficents.append(g_list[m][i]*np.sqrt(pSobolev_sigma_list[i]))
    func_norm = np.linalg.norm(np.asarray(normalized_coefficents))
    list_of_functions.append(abstract_mean_element('','periodic Sobolev',mean_element(1,g_list[m],pSobolev_sigma_list,onb_list),func_norm))
    list_of_norms.append(list_of_functions[m].norm)

list_of_n = [1,10,20]



error_array_1 = np.zeros((N_exp,len(n_list)))
error_array_2 = np.zeros((N_exp,len(n_list)))
error_array_3 = np.zeros((N_exp,len(n_list)))
####################################################
####################################################  
####################################################




####################################################
#################### The simulation ################  
####################################################

print("A numerical simulation of OKQ in the case of the periodic Sobolev space of order s= "+str(kernel_order))

for n in n_list:
    N_perfect = get_N_perfect_1D(multi_indices)[n][0]
    print("Simulation of " +str(N_exp)+ " configurations of N = "+str(n)+" nodes")
    for _ in list(range(N_exp)):
        ## Generate the sequence
        seq = np.asarray(dpp_sampler(n,1,'spectral',multi_indices,N_perfect) )
        ## Calculate the kernel matrix
        kernel_matrix = my_kernel.get_kernel_matrix(seq)        
        ## Evaluate the approximation errors
        error_array_1[_,n_list.index(n)] =  suponlist_interpolation_error_okq(seq,kernel_matrix,kernel_matrix,[list_of_functions[0]],[list_of_norms[0]],[1])
        error_array_2[_,n_list.index(n)] =  suponlist_interpolation_error_okq(seq,kernel_matrix,kernel_matrix,[list_of_functions[1]],[list_of_norms[1]],[10])
        error_array_3[_,n_list.index(n)] =  suponlist_interpolation_error_okq(seq,kernel_matrix,kernel_matrix,[list_of_functions[2]],[list_of_norms[2]],[20])


        
mean_error_array_1 = np.mean(error_array_1, axis = 0)
mean_error_array_2 = np.mean(error_array_2, axis = 0)
mean_error_array_3 = np.mean(error_array_3, axis = 0)



dpp_c_rate_n_list = list(range(10*max(n_list)))
dpp_c_rate = sigma_seq(dpp_c_rate_n_list,kernel_order)
ezq_rate_list = ezq_rate(dpp_c_rate_n_list,dpp_c_rate)
colors = plt.cm.Reds(np.linspace(0,1,6))


### Plot number 1
fig1, ax1 = plt.subplots(figsize=(7, 5))
ax1.set_xscale('log')
ax1.set_xticks([10, 20,30, 50,100])
ax1.get_xaxis().set_major_formatter(mpl.ticker.ScalarFormatter())
plt.grid(alpha=0.6, linestyle=':')

plt.plot(n_list,np.log(mean_error_array_1)/np.log(10), label= r'$\epsilon_{1}^{\mathrm{OKQ}}(N)$',linestyle='-', marker='.',linewidth=2, color= colors[6-1])
plt.plot(n_list,np.log(mean_error_array_2)/np.log(10), label= r'$\epsilon_{10}^{\mathrm{OKQ}}(N)$',linestyle='-', marker='.',linewidth=2, color= colors[6-2])
plt.plot(n_list,np.log(mean_error_array_3)/np.log(10), label= r'$\epsilon_{20}^{\mathrm{OKQ}}(N)$',linestyle='-', marker='.',linewidth=2, color= colors[6-3])
plt.plot(dpp_c_rate_n_list[5:max(n_list)],np.log(ezq_rate_list[5:max(n_list)])/np.log(10), label= r'$\mathrm{r}_{N+1}$',linestyle='--',linewidth=3, color='#0066ff')
plt.plot(dpp_c_rate_n_list[5:max(n_list)],np.log(dpp_c_rate[5:max(n_list)])/np.log(10), label= r'$\sigma_{N+1}$',linestyle='--',linewidth=3, color='black')


plt.legend( loc='upper right', bbox_to_anchor=(1,1), fontsize=12)
plt.xlabel(r'$\log_{10} (\mathrm{N})$', fontsize=18)
plt.xticks( fontsize=18)
plt.ylabel(r'$\log_{10}$'+"(Squared error)", fontsize=18)
plt.yticks(fontsize=18)
plt.savefig('results/okq_pSobolev_s_'+str(kernel_order)+'.pdf')
plt.show()



