
import numpy as np






def Calculate_alpha_subspace_kernel_regression_inv(K,f_values):
    # K is NxN kernel matrix evaluated at the nodes
    # f_values is the vector of the evaluation of f at the N nodes
    # N is the number of nodes
    [N,_] = K.shape
    alpha = np.dot(np.linalg.inv(K),f_values)
    return alpha



def evaluate_EZquadrature_on_eigfunc(weights,nodes,sigma,function_evals,pkernel_matrix,kernel_matrix):
    # This function evaluate the RKHS norm defined by a kernel of a quadrature  
    # weights is the array of weights
    # nodes is the array of nodes
    # my_function is the function
    # my_kernel is the kernel
    output_var = sigma*(1 - 2*np.dot(weights,function_evals)) + np.dot(np.dot(weights.T,kernel_matrix),weights)
    
    return output_var


def evaluate_quadrature_on_eigfunc(weights,nodes,sigma,function_evals,pkernel_matrix,kernel_matrix):
    # This function evaluate the RKHS norm defined by a kernel of a quadrature  
    # weights is the array of weights
    # nodes is the array of nodes
    # my_function is the function
    # my_kernel is the kernel
    N = len(nodes)
    #print(weights)

    #output_var = max(1 - 2*np.dot(weights,function_evals) + np.dot(np.dot(weights.T,kernel_matrix),weights),0)
    output_var = sigma - 2*np.dot(weights,function_evals) + np.dot(np.dot(weights.T,kernel_matrix),weights)
    
    return output_var


def suponlist_interpolation_error_ezq(seq,pkernel_matrix,kernel_matrix,list_of_functions,list_of_norms,list_of_n):
    error_list = []
    counter = 0
    for func in list_of_functions:
        n = list_of_n[0]
        tmp_func_evals = func.evaluate(seq)#
        func_evals = [x for x in tmp_func_evals]
        if len(seq)<n:
            alpha = np.zeros(len(seq))
        else:
            alpha = Calculate_alpha_subspace_kernel_regression_inv(pkernel_matrix,func_evals)
        error_list.append(evaluate_EZquadrature_on_eigfunc(alpha,seq,np.power(func.norm,2),func_evals,pkernel_matrix,kernel_matrix))
        counter = counter +1
    return max(error_list)

def suponlist_interpolation_error_okq(seq,pkernel_matrix,kernel_matrix,list_of_functions,list_of_norms,list_of_n):
    error_list = []
    counter = 0
    for func in list_of_functions:
        tmp_func_evals = func.evaluate(seq)#
        func_evals = [x for x in tmp_func_evals]
        alpha = Calculate_alpha_subspace_kernel_regression_inv(pkernel_matrix,func_evals)
        error_list.append(evaluate_quadrature_on_eigfunc(alpha,seq,np.power(func.norm,2),func_evals,pkernel_matrix,kernel_matrix))
        counter = counter +1
    return max(error_list)
