# Supplementary materials for submission 28451

## Manuscript title

OPC: One-Point-Contraction unlearning toward deep feature forgetting

## Index


- `ckpt/` : checkpoints of pretrained model and unlearned model for cifar10 with 30% class unlearning scenario
  - checkpoints of other unlearning methods are omitted due to file size limit(100MB)

- `CKA_src` : source code for the CKA similarity computation.
  - original repo: https://github.com/numpee/CKA.pytorch

- `inversion_src`: source code for the unlearning inversion attack
  - origianl repo: https://github.com/TASI-LAB/Unlearning-inversion-attacks
    - inheritance from: https://github.com/JonasGeiping/invertinggradients

- `salun_src` : source code for model and dataset preparation, metrics, etc.
  - origianl repo: https://github.com/OPTML-Group/Unlearn-Saliency
  - `salun_src/Classification/unlearn/OPC.py`: source code of OPC training.
    - To run: clone SalUn repo, put `OPC.py` into `unlearn/` and run `main_forget.py` with `--unlearn=OPC`.
  - `salun_src/DDPM/train.py`: source code of DDPM decoder training.
    - To run: clone SalUn repo, put `cifar10_recon.yml` into `configs/`, and add the code in `ddpm_decoder.py` to the bottom of the `runners/diffusion.py`  and run `train.py` with `--mode=recon`.

- `SD_src` : source code for stable diffusion unlearning.
  - `SD_src/train_auxiliary_layer.py`: source code of Auxiliary layer training.
    - To run: you can choice the domain('style', 'class') in line 37. Then run `train_auxiliary_layer.py`
  - `SD_src/text_encoder_opc.py`: source code of OPC training
    - To run: you can modify the theme in `train_text_encoder_opc.sh`, then run `train_text_encoder_opc.py`

- `main.py`: evaluation script for our unlearned model. 
  - Evaluation criteria:
    - accuracies on forget set, retain set, test set
    - MIA^e: MIA efficacy score
    - FM-recovery: result with feature mapping recovery attack.
    - HR-recovery: result with head recovery attack
    - OPC-TF: result with training-free unlearning under OPC strategy
    - RL-TF: result with training-free unlearning under RL strategy
    - CKA: CKA similarity scores compared to the pretrained model.
        - feature: features of model, before the prediction head
        - logit: predicted logits, after the prediction head

- `inversion_main`: unlearning inversion attack script.

## How to run

- docker image: `nvcr.io/nvidia/pytorch:23.11-py3`, 

```sh
docker build -t iclr2026_opc .
docker run --rm --gpus all iclr2026_opc # automatically evaluates OPC model on CIFAR10+class30% unlearning

```


