import os
import shutil
from datetime import datetime


def get_str_experiments(flags):
    dateTimeObj = datetime.now()
    dateStr = dateTimeObj.strftime("%Y_%m_%d_%H_%M_%S_%f")
    str_experiments = flags.dataset + '_' + dateStr
    return str_experiments

def set_exp_flags(flags, train=True):
    if train:
        str_experiments = get_str_experiments(flags)
        flags.dir_experiment_run = flags.dir_experiment
        flags.str_experiment = ''
    else:
        flags.dir_experiment_run = flags.dir_experiment

    print(flags.dir_experiment_run)

    flags.dir_checkpoints = os.path.join(flags.dir_experiment_run, 'checkpoints')

    flags.dir_logs = os.path.join(flags.dir_experiment_run, 'logs')
    print(flags.dir_logs)

    flags.dir_logs_clf = os.path.join(flags.dir_experiment_run, 'logs_clf')

    flags.dir_gen_eval = os.path.join(flags.dir_experiment_run, 'generation_evaluation')

    flags.dir_inference = os.path.join(flags.dir_experiment_run, 'inference')

    if flags.dir_fid is None:
        flags.dir_fid = flags.dir_experiment_run
    elif not train:
        flags.dir_fid = os.path.join(flags.dir_experiment_run, 'fid_eval')
        if not os.path.exists(flags.dir_fid):
            os.makedirs(flags.dir_fid)
    flags.dir_gen_eval_fid = os.path.join(flags.dir_fid, 'fid')

    flags.dir_plots = os.path.join(flags.dir_experiment_run, 'plots')
    flags.dir_swapping = os.path.join(flags.dir_plots, 'swapping')

    flags.dir_random_samples = os.path.join(flags.dir_plots, 'random_samples')

    flags.dir_cond_gen = os.path.join(flags.dir_plots, 'cond_gen')
    return flags
