from smuco.sac import sac
from smuco.stc import build_exp
from smuco.basic_manipulation import BasicManipulationEnv, get_basic_manip_env

import hydra
import os
from omegaconf import DictConfig, OmegaConf, open_dict

@hydra.main(version_base=None, config_path="conf", config_name="cheetah_run")
def main(cfg):
    os.system('mkdir -p ' + cfg.exp_dir.base)
    env_fn = lambda: get_basic_manip_env(cfg.num_of_cameras) 
        
    exp = build_exp(cfg)
    logger_kwargs = {
        'output_dir' : cfg.exp_dir.base,
        'exp_name' : cfg.domain + "_" + cfg.task,
    }
    sac(cfg, env_fn, exp, logger_kwargs=logger_kwargs)
        

if __name__ == "__main__":
    main()