from smuco.sac import sac
from smuco.stc import build_exp

import dmc2gym
import hydra
import os
from omegaconf import DictConfig, OmegaConf, open_dict

@hydra.main(version_base=None, config_path="conf", config_name="walker_walk")
def main(cfg):
    os.system('mkdir -p ' + cfg.exp_dir.base)
    env_fn = lambda : dmc2gym.make(
        domain_name=cfg.domain,
        task_name=cfg.task,
        seed=cfg.seed,
        from_pixels=True,
        visualize_reward=False,
    )
    
    exp = build_exp(cfg)
    logger_kwargs = {
        'output_dir' : cfg.exp_dir.base,
        'exp_name' : cfg.domain + "_" + cfg.task,
    }
    sac(cfg, env_fn, exp, logger_kwargs=logger_kwargs)
        

if __name__ == "__main__":
    main()