# this file generates the data for the synthetic tabular plots
import numpy as np
import cascading_alg as c_alg
import other_alg as o_alg
import time

start = time.time()  # to see how long the entire experiment takes
n, L, trials = 100000, 100, 5  # horizon, number of items, and number of trials
all_tests = np.arange(4, 18, 2)  # all values of K tested
num_tests = all_tests.shape[0]  # number of tests

for test_idx in range(num_tests):
    K = all_tests.astype(int)[test_idx]  # current value of K
    regret, runtime = np.zeros((3, n, trials)), np.zeros((3, trials))
    print('starting K = ' + str(K))
    for trial_idx in range(trials):
        # generate tabular instance, run three tabular algorithms, print progress update
        start_trial = time.time()
        reward = o_alg.tab_instance(L, K)
        regret[0, :, trial_idx], runtime[0, trial_idx] = c_alg.cascade_ucb1(n, K, reward)
        regret[1, :, trial_idx], runtime[1, trial_idx] = c_alg.cascade_ucbV(n, K, reward)
        regret[2, :, trial_idx], runtime[2, trial_idx] = c_alg.cascade_klucb(n, K, reward, 1e-4)
        print('trial ' + str(trial_idx + 1) + ' of ' + str(trials) + ' done, time = ' + str(time.time() - start_trial))
    np.savez('results/syn_tab_' + str(K), regret, runtime)  # save results for later plotting

print('total time = ' + str(time.time() - start))  # show how long the entire experiment took
