###
# IMPORTS
###
import numpy as np
import sys
import os
sys.path.append(os.getcwd())

from src.envs.LevelForagingEnv import LevelForagingEnv,Agent,Task, load_default_scenario

###
# Setting the environment
###
display = True
dim = (10,10)
visibility = 'partial'
method = 'pomcp'
estimation_method = None

"""
### Components templates ###
# - if you want to run a custom scenario, remove this comment block, modify the
# scenario components and above settings, then comment the two lines below, which
# run the default scenarios.

components = {
    'agents' : [
            Agent(index='A',atype=method,position=(1,1),direction=1*np.pi/2,radius=0.25,angle=1,level=1.0),
            Agent(index='1',atype='l1',position=(8,1),direction=1*np.pi/2,radius=0.25,angle=1,level=0.2),
            Agent(index='2',atype='l2',position=(1,8),direction=1*np.pi/2,radius=0.25,angle=1,level=0.4),
            Agent(index='3',atype='l3',position=(8,9),direction=1*np.pi/2,radius=0.25,angle=1,level=0.6)
                ],
    'adhoc_agent_index' : 'A',
    'tasks' : [
            Task(index='0',position=(8,8),level=1.0),
            Task(index='1',position=(5,5),level=0.9),
            Task(index='2',position=(0,0),level=0.7),
            Task(index='3',position=(9,1),level=1.0)
                ]
}

env = LevelForagingEnv(shape=dim,components=components,visibility=visibility,display=display)
"""

scenario_id = 1
env, scenario_id = load_default_scenario(method,scenario_id,display=display)

###
# ADLEAP-MAS MAIN ROUTINE
###
state = env.reset()

done, max_episode = False, 200
while env.episode < max_episode and not done:
    print('|||| Episode',env.episode)
    # 1. Importing agent method
    adhoc_agent = env.get_adhoc_agent()
    method = env.import_method(adhoc_agent.type)

    # 2. Reasoning about next action and target
    action, target = method(state, adhoc_agent)

    # 3. Taking a step in the environment
    state, reward, done, info = env.step(action)

    adhoc_agent.show_memory()

env.close()
###
# THE END - That's all folks :)
###
