# Copyright (c) 2021-2022, NVIDIA Corporation & Affiliates. All rights reserved.
#
# This work is made available under the Nvidia Source Code License-NC.
# To view a copy of this license, visit
# https://github.com/NVlabs/FAN/blob/main/LICENSE

_base_ = [
    '../../_base_/models/segformer.py',
    '../../_base_/datasets/cityscapes_1024x1024_repeat.py',
    # '../../_base_/datasets/cityscapes_768x768_repeat.py',
    '../../_base_/default_runtime.py',
    '../../_base_/schedules/schedule_160k_8gpu_adamw.py'
]

# model settings
norm_cfg = dict(type='SyncBN', requires_grad=True)
find_unused_parameters = False
model = dict(
    type='EncoderDecoder',
    pretrained='pretrained/fan_large_16_p4_hybrid.pth.tar',
    backbone=dict(
        type='fan_large_16_p4_hybrid',
        style='pytorch'),
    decode_head=dict(
        type='SegFormerHead',
        in_channels=[128, 256, 480, 480],
        in_index=[0, 1, 2, 3],
        feature_strides=[4, 8, 16, 32],
        channels=256,
        dropout_ratio=0.1,
        num_classes=19,
        norm_cfg=norm_cfg,
        align_corners=False,
        decoder_params=dict(embed_dim=768),
        loss_decode=dict(type='CrossEntropyLoss', use_sigmoid=False, loss_weight=1.0)),
    # model training and testing settings
    train_cfg=dict(),
    test_cfg=dict(mode='slide', crop_size=(1024,1024), stride=(768,768)))

# data
data = dict(samples_per_gpu=1)
evaluation = dict(interval=4000, metric='mIoU')

# optimizer
optimizer = dict(_delete_=True, type='AdamW', lr=0.00006, betas=(0.9, 0.999), weight_decay=0.01,
                 paramwise_cfg=dict(custom_keys={'pos_block': dict(decay_mult=0.),
                                                 'norm': dict(decay_mult=0.),
                                                 'head': dict(lr_mult=10.)
                                                 }))

lr_config = dict(_delete_=True, policy='poly',
                 warmup='linear',
                 warmup_iters=1500,
                 warmup_ratio=1e-6,
                 power=1.0, min_lr=0.0, by_epoch=False)

# uncomment to use fp16 training
# optimizer_config = dict(type='Fp16OptimizerHook', loss_scale='dynamic', grad_clip=dixt(max_norm=32, norm_type=2))
# fp16 = dict()
# fp16 = dict(loss_scale='dynamic')
