#  Extending Prediction-Powered Inference through Conformal Prediction

This repository accompanies the paper **“Extending Prediction-Powered Inference through Conformal Prediction”** and provides everything needed to reproduce its empirical results.

## Table of Contents

1. [Repository layout](#repository-layout)
2. [Dependencies](#dependencies)
3. [Running the experiments](#running-the-experiments)

## Repository layout

```
conformal-ppi/
│  pyproject.toml        # project metadata & dependencies
│  uv.lock               # fully pinned lock‑file (generated by `uv`)
│  README.md             # <–– you are here
│
└─ supplementary/        # source code for the experiments
    ├─ util/             # generic helpers (CIs, estimators, etc.)
    ├─ datasets/         # pre‑packed data files used in the paper
    ├─ experiment1/      # Fig. 1 – mean & quantile estimation
    ├─ experiment2/      # Fig. 2 – prediction-powered inference with differential‑privacy
    ├─ experiment3/      # Fig. 3 – anytime-valid risk monitoring with e‑values
    └─ fab_ppi/          # FAB code
```

# Dependencies

Dependency management is being done with [uv](https://docs.astral.sh/uv/). To install the dependencies, cd into this repository and run:

```bash
$ uv sync
```

To run the scripts, use Python's `-m` flag (from inside uv), e.g.:

```bash
$ uv run python -m supplementary.datasets
```

Alternatively, you can active your environment and then run the python commands without `uv run`. All commands below are stated without `uv run`.

## Running the experiments

### Fetch Datasets

To download the datasets used, run:

```bash
python -m supplementary.datasets
```

This will download the datasets and save them in the `datasets/` folder.

### Experiment 1 – Mean & Quantile Estimation (Figure 1)

```bash
# mean (phishing dataset) – produces CSV + fig1_all.png in results/
python -m supplementary.experiment1.mean_estimation

# median (gene‑expression dataset)
python -m supplementary.experiment1.quantile_estimation

# assemble the multi‑panel Figure 1
python -m supplementary.experiment1.plot
```

### Experiment 2 – Differential‑Privacy Scenario (Figure 2)

```bash
python -m supplementary.experiment2.diff_priv      # fig3.png
```

### Experiment 3 – E‑Value Inference (Figure 3)

```bash
python -m supplementary.experiment3.evalues        # fig4.png
```
