from typing import Any, Callable, Tuple

import scipy.integrate as integrate


def shift_integrand(integrand: Callable, offset: float) -> Callable:
    def shifted_integrand(x):
        return integrand(x - offset)

    return shifted_integrand


def quad(
    func: Callable,
    a: float,
    b: float,
    midpoint: float = 0.0,
    **kwargs: Any,
) -> Tuple[float, float]:
    if midpoint != 0.0:
        func = shift_integrand(func, -midpoint)
    return integrate.quad(func, a, b, **kwargs)
