from icecream import ic  # type: ignore
import numpy as np
from ucimlrepo import fetch_ucirepo  # type: ignore
from scipy import stats


def clt_confidence_interval(data, *, alpha: float = 0.05, **kwargs):
    # Convert data to numpy array
    data = np.array(data)
    sample_size = len(data)

    # Calculate sample statistics
    sample_mean = np.mean(data, axis=0)
    sample_std = np.std(data, ddof=1, axis=0)  # ddof=1 for sample standard deviation


    # Calculate standard error
    standard_error = sample_std / np.sqrt(sample_size)

    # Find critical value (z-score for large samples)
    critical_value = stats.norm.ppf(1 - alpha / 2)

    # Calculate margin of error
    margin_of_error = critical_value * standard_error

    # Calculate confidence interval
    lower_bound = sample_mean - margin_of_error
    upper_bound = sample_mean + margin_of_error

    return lower_bound, sample_mean, upper_bound


def hoeffding_confidence_interval(data, *, alpha: float = 0.05, M: float = 1):
    # Convert data to numpy array
    data = np.array(data)

    # Calculate sample statistics
    sample_mean = np.mean(data, axis=0)
    sample_size = len(data)

    # Calculate margin of error
    margin_of_error = M * np.sqrt(np.log(1 / alpha) / (2 * sample_size))

    # Calculate confidence interval
    lower_bound = sample_mean - margin_of_error
    upper_bound = sample_mean + margin_of_error

    return lower_bound, sample_mean, upper_bound

def covarage_set(thetas,*, lower_bound, upper_bound):
    lower_below_zero = lower_bound <= 0
    upper_above_zero = upper_bound >= 0
    between_zero = lower_below_zero & upper_above_zero
    return thetas[between_zero]