# Noise-contrastive Variational Information Bottleneck Networks for Uncertainty Estimation 

## Requirements

This code was tested on Python 3.6.9 with PyTorch 1.6.0 and CUDA 10.2.

All requirements are summarized in ``requirements.txt``.
An easy way to install the required packages is setting up an Anaconda environment.

```
conda config --add channels pytorch
conda create -n <environment_name> --file requirements.txt
conda activate <environment_name>
```

## Data Preprocessing


### Image Classification on [ImageNet](http://image-net.org/download)

We rescale all images so that the smaller image dimension equals 256px.



## Training and Evaluation

The commands required to train and evaluate the models in the paper can be found in the ``commands.md`` file.


## Results

Our models achieve the following performance:

### Image Classification on CIFAR-10

|       Model        | Misclass. |  NLLH  |   ECE   |  AUMRC  |
| ------------------ | --------- | ------ | ------- | ------- |
|  ResNet18 NCIDO    |   5.09%   | 0.174  |  0.0190 |  0.0053 |
|  ResNet18 NCVIBN   |   4.93%   | 0.165  |  0.0128 |  0.0057 |
|  ResNet18 NCVIBNMP |   4.74%   | 0.164  |  0.0116 |  0.0056 |

### Image Classification on CIFAR-100

|       Model        | Misclass. |  NLLH  |   ECE   |  AUMRC  |
| ------------------ | --------- | ------ | ------- | ------- |
|  ResNet18 NCIDO    |   25.35%  |  1.117 |  0.0906 |  0.0738 |
|  ResNet18 NCVIBN   |   25.16%  |  1.009 |  0.0558 |  0.0797 |
|  ResNet18 NCVIBNMP |   25.07%  |  1.044 |  0.0672 |  0.0783 |

### Image Classification on Tiny ImageNet

|       Model        | Misclass. |  NLLH  |   ECE   |  AUMRC  |
| ------------------ | --------- | ------ | ------- | ------- |
|  ResNet18 NCIDO    |   42.09%  |  1.784 |  0.0490 |  0.1762 |
|  ResNet18 NCVIBN   |   41.82%  |  1.756 |  0.0660 |  0.1757 |
|  ResNet18 NCVIBNMP |   41.46%  |  1.781 |  0.0935 |  0.1691 |

### Image Classification on ImageNet

|        Model      | Misclass. |  NLLH  |   ECE   |  AUMRC  |
| ----------------- | --------- | ------ | ------- | ------- |
| ResNet50 LLNCVIBN |   24.34%  |  0.974 |  0.0228 |  0.0756 |