## Commands

### Training commands

To train ResNet18 on CIFAR-10:
```
python main.py --batch_size=128 --loss=ClassificationLoss --lr_scheduler=MultiStepLR --lr_scheduler_gamma=0.2 --lr_scheduler_milestones="[60,120,160]" --model=ResNet18 --model_num_classes=10 --num_workers=4 --optimizer=SGD --optimizer_nesterov=True --optimizer_momentum=0.9 --optimizer_lr=0.1 --optimizer_weight_decay=1e-4  --total_epochs=200 --training_dataset=Cifar10Train --training_dataset_root=data/cifar10 --training_key=xe --validation_dataset=Cifar10Valid --validation_dataset_root=data/cifar10 --validation_keys="[top1,xe]" --validation_keys_minimize="[False,True]" --device=cuda:0 --save=output/ResNet18-Cifar10
```

To train ResNet18 on CIFAR-100:
```
python main.py --batch_size=128 --loss=ClassificationLoss --lr_scheduler=MultiStepLR --lr_scheduler_gamma=0.2 --lr_scheduler_milestones="[60,120,160]" --model=ResNet18 --model_num_classes=100 --num_workers=4 --optimizer=SGD --optimizer_nesterov=True --optimizer_momentum=0.9 --optimizer_lr=0.1 --optimizer_weight_decay=1e-4  --total_epochs=200 --training_dataset=Cifar100Train --training_dataset_root=data/cifar100 --training_key=xe --validation_dataset=Cifar100Valid --validation_dataset_root=data/cifar100 --validation_keys="[top1,xe]" --validation_keys_minimize="[False,True]" --device=cuda:0 --save=output/ResNet18-Cifar100
```

To train ResNet18 on Tiny ImageNet:
```
python main.py --batch_size=64 --loss=ClassificationLoss --lr_scheduler=MultiStepLR --lr_scheduler_gamma=0.1 --lr_scheduler_milestones="[30,40,50]" --model=ResNet18--model_num_classes=200 --num_workers=4 --optimizer=SGD --optimizer_nesterov=True --optimizer_momentum=0.9 --optimizer_lr=0.1 --optimizer_weight_decay=1e-4  --total_epochs=60 --training_dataset=TinyImageNetTrain --training_dataset_root=data/tinyimagenet/train --training_key=xe --validation_dataset=TinyImageNetValid --validation_dataset_root=data/tinyimagenet/val --validation_keys="[top1,xe]" --validation_keys_minimize="[False,True]" --device=cuda:0 --save=output/ResNet18-TinyImageNet --model_maxpool=True
```

To train ResNet18 VIBN on CIFAR-10:
```
python main.py --batch_size=128 --loss=ClassificationLossVIBN --lr_scheduler=MultiStepLR --lr_scheduler_gamma=0.2 --lr_scheduler_milestones="[60,120,160]" --model=ResNet18VIBN --model_num_classes=10 --num_workers=4 --optimizer=SGD --optimizer_nesterov=True --optimizer_momentum=0.9 --optimizer_lr=0.1 --optimizer_weight_decay=1e-4  --total_epochs=200 --training_dataset=Cifar10Train --training_dataset_root=data/cifar10 --training_key=total_loss --validation_dataset=Cifar10Valid --validation_dataset_root=data/cifar10 --validation_keys="[top1,xe]" --validation_keys_minimize="[False,True]" --device=cuda:0 --save=output/ResNet18VIBN-Cifar10 --model_training_samples=2 --loss_vibn_weight=1e-3 --loss_annealed_iterations=21120
```

To train ResNet18 VIBN on CIFAR-100:
```
python main.py --batch_size=128 --loss=ClassificationLossVIBN --lr_scheduler=MultiStepLR --lr_scheduler_gamma=0.2 --lr_scheduler_milestones="[60,120,160]" --model=ResNet18VIBN --model_num_classes=100 --num_workers=4 --optimizer=SGD --optimizer_nesterov=True --optimizer_momentum=0.9 --optimizer_lr=0.1 --optimizer_weight_decay=1e-4  --total_epochs=200 --training_dataset=Cifar100Train --training_dataset_root=data/cifar100 --training_key=total_loss --validation_dataset=Cifar100Valid --validation_dataset_root=data/cifar100 --validation_keys="[top1,xe]" --validation_keys_minimize="[False,True]" --device=cuda:0 --save=output/ResNet18VIBN-Cifar100 --model_training_samples=2 --loss_vibn_weight=1e-3 --loss_annealed_iterations=21120
```

To train ResNet18 VIBN on Tiny ImageNet:
```
python main.py --batch_size=64 --loss=ClassificationLossVIBN --lr_scheduler=MultiStepLR --lr_scheduler_gamma=0.1 --lr_scheduler_milestones="[30,40,50]" --model=ResNet18VIBN --model_num_classes=200 --num_workers=4 --optimizer=SGD --optimizer_nesterov=True --optimizer_momentum=0.9 --optimizer_lr=0.1 --optimizer_weight_decay=1e-4  --total_epochs=60 --training_dataset=TinyImageNetTrain --training_dataset_root=data/tinyimagenet/train --training_key=total_loss --validation_dataset=TinyImageNetValid --validation_dataset_root=data/tinyimagenet/val --validation_keys="[top1,xe]" --validation_keys_minimize="[False,True]" --device=cuda:0 --save=output/ResNet18VIBN-TinyImageNet --model_training_samples=2 --loss_vibn_weight=1e-3 --loss_annealed_iterations=46920 --model_maxpool=True
```

To train ResNet18 IDO on CIFAR-10:
```
python main.py --batch_size=128 --loss=ClassificationLossVIBN --lr_scheduler=MultiStepLR --lr_scheduler_gamma=0.2 --lr_scheduler_milestones="[60,120,160]" --model=ResNet18IDO --model_num_classes=10 --num_workers=4 --optimizer=SGD --optimizer_nesterov=True --optimizer_momentum=0.9 --optimizer_lr=0.1 --optimizer_weight_decay=1e-4  --total_epochs=200 --training_dataset=Cifar10Train --training_dataset_root=data/cifar10 --training_key=total_loss --validation_dataset=Cifar10Valid --validation_dataset_root=data/cifar10 --validation_keys="[top1,xe]" --validation_keys_minimize="[False,True]" --device=cuda:0 --save=output/ResNet18IDO-Cifar10 --model_training_samples=2 --loss_vibn_weight=1e-3 --loss_annealed_iterations=21120
```

To train ResNet18 IDO on CIFAR-100:
```
python main.py --batch_size=128 --loss=ClassificationLossVIBN --lr_scheduler=MultiStepLR --lr_scheduler_gamma=0.2 --lr_scheduler_milestones="[60,120,160]" --model=ResNet18IDO --model_num_classes=100 --num_workers=4 --optimizer=SGD --optimizer_nesterov=True --optimizer_momentum=0.9 --optimizer_lr=0.1 --optimizer_weight_decay=1e-4  --total_epochs=200 --training_dataset=Cifar100Train --training_dataset_root=data/cifar100 --training_key=total_loss --validation_dataset=Cifar100Valid --validation_dataset_root=data/cifar100 --validation_keys="[top1,xe]" --validation_keys_minimize="[False,True]" --device=cuda:0 --save=output/ResNet18IDO-Cifar100 --model_training_samples=2 --loss_vibn_weight=1e-3 --loss_annealed_iterations=21120
```

To train ResNet18 IDO on Tiny ImageNet:
```
python main.py --batch_size=64 --loss=ClassificationLossVIBN --lr_scheduler=MultiStepLR --lr_scheduler_gamma=0.1 --lr_scheduler_milestones="[30,40,50]" --model=ResNet18IDO --model_num_classes=200 --num_workers=4 --optimizer=SGD --optimizer_nesterov=True --optimizer_momentum=0.9 --optimizer_lr=0.1 --optimizer_weight_decay=1e-4  --total_epochs=60 --training_dataset=TinyImageNetTrain --training_dataset_root=data/tinyimagenet/train --training_key=total_loss --validation_dataset=TinyImageNetValid --validation_dataset_root=data/tinyimagenet/val --validation_keys="[top1,xe]" --validation_keys_minimize="[False,True]"  --device=cuda:0 --save=output/ResNet18IDO-TinyImageNet --model_training_samples=2 --loss_vibn_weight=1e-3 --loss_annealed_iterations=46920 --model_maxpool=True
```

To train ResNet18 VIBNMP on CIFAR-10:
```
python main.py --batch_size=128 --loss=ClassificationLossVIBN --lr_scheduler=MultiStepLR --lr_scheduler_gamma=0.2 --lr_scheduler_milestones="[60,120,160]" --model=ResNet18VIBN --model_num_classes=10 --num_workers=4 --optimizer=SGD --optimizer_nesterov=True --optimizer_momentum=0.9 --optimizer_lr=0.1 --optimizer_weight_decay=1e-4  --total_epochs=200 --training_dataset=Cifar10Train --training_dataset_root=data/cifar10 --training_key=total_loss --validation_dataset=Cifar10Valid --validation_dataset_root=data/cifar10 --validation_keys="[top1,xe]" --validation_keys_minimize="[False,True]" --device=cuda:0 --save=output/ResNet18VIBNMP-Cifar10 --model_training_samples=2 --loss_vibn_weight=1e-3 --loss_annealed_iterations=21120
```

To train ResNet18 VIBNMP on CIFAR-100:
```
python main.py --batch_size=128 --loss=ClassificationLossVIBN --lr_scheduler=MultiStepLR --lr_scheduler_gamma=0.2 --lr_scheduler_milestones="[60,120,160]" --model=ResNet18VIBN --model_num_classes=100 --num_workers=4 --optimizer=SGD --optimizer_nesterov=True --optimizer_momentum=0.9 --optimizer_lr=0.1 --optimizer_weight_decay=1e-4  --total_epochs=200 --training_dataset=Cifar100Train --training_dataset_root=data/cifar100 --training_key=total_loss --validation_dataset=Cifar100Valid --validation_dataset_root=data/cifar100 --validation_keys="[top1,xe]" --validation_keys_minimize="[False,True]" --device=cuda:0 --save=output/ResNet18VIBNMP-Cifar100 --model_training_samples=2 --loss_vibn_weight=1e-3 --loss_annealed_iterations=21120
```

To train ResNet18 VIBNMP on Tiny ImageNet:
```
python main.py --batch_size=64 --loss=ClassificationLossVIBN --lr_scheduler=MultiStepLR --lr_scheduler_gamma=0.1 --lr_scheduler_milestones="[30,40,50]" --model=ResNet18VIBNMP --model_num_classes=200 --num_workers=4 --optimizer=SGD --optimizer_nesterov=True --optimizer_momentum=0.9 --optimizer_lr=0.1 --optimizer_weight_decay=1e-4  --total_epochs=60 --training_dataset=TinyImageNetTrain --training_dataset_root=data/tinyimagenet/train --training_key=total_loss --validation_dataset=TinyImageNetValid --validation_dataset_root=data/tinyimagenet/val --validation_keys="[top1,xe]" --validation_keys_minimize="[False,True]" --device=cuda:0 --save=output/ResNet18VIBNMP-TinyImageNet --model_training_samples=2 --loss_vibn_weight=1e-3 --loss_annealed_iterations=46920 --model_maxpool=True
```

To train ResNet18 NCVIBN on CIFAR-10:
```
python main.py --batch_size=128 --loss=ClassificationLossNCVIBN --lr_scheduler=MultiStepLR --lr_scheduler_gamma=0.2 --lr_scheduler_milestones="[60,120,160]" --model=ResNet18NCVIBN --model_num_classes=10 --num_workers=4 --optimizer=SGD --optimizer_nesterov=True --optimizer_momentum=0.9 --optimizer_lr=0.1 --optimizer_weight_decay=1e-4  --total_epochs=200 --training_dataset=Cifar10Train --training_dataset_root=data/cifar10 --training_key=total_loss --validation_dataset=Cifar10Valid --validation_dataset_root=data/cifar10 --validation_keys="[top1,xe]" --validation_keys_minimize="[False,True]" --optimizer_group="{'params': '*decoder*', 'weight_decay': 0.0}" --device=cuda:0 --save=output/ResNet18NCVIBN-Cifar10 --model_training_samples=2 --model_prior_precision=1e-1 --model_var_dampening=1e-2 --loss_vibn_weight=1e-4 --loss_decoder_kld_weight=2e-5 --loss_annealed_iterations=21120
```

To train ResNet18 NCVIBN on CIFAR-100:
```
python main.py --batch_size=128 --loss=ClassificationLossNCVIBN --lr_scheduler=MultiStepLR --lr_scheduler_gamma=0.2 --lr_scheduler_milestones="[60,120,160]" --model=ResNet18NCVIBN --model_num_classes=100 --num_workers=4 --optimizer=SGD --optimizer_nesterov=True --optimizer_momentum=0.9 --optimizer_lr=0.1 --optimizer_weight_decay=1e-4  --total_epochs=200 --training_dataset=Cifar100Train --training_dataset_root=data/cifar100 --training_key=total_loss --validation_dataset=Cifar100Valid --validation_dataset_root=data/cifar100 --validation_keys="[top1,xe]" --validation_keys_minimize="[False,True]" --optimizer_group="{'params': '*decoder*', 'weight_decay': 0.0}" --device=cuda:0 --save=output/ResNet18NCVIBN-Cifar100 --model_training_samples=2 --model_prior_precision=1e-1 --model_var_dampening=1e-2 --loss_vibn_weight=1e-4 --loss_decoder_kld_weight=2e-5 --loss_annealed_iterations=21120
```

To train ResNet18 NCVIBN on Tiny ImageNet:
```
python main.py --batch_size=64 --loss=ClassificationLossNCVIBN --lr_scheduler=MultiStepLR --lr_scheduler_gamma=0.1 --lr_scheduler_milestones="[30,40,50]" --model=ResNet18NCVIBN --model_num_classes=200 --num_workers=4 --optimizer=SGD --optimizer_nesterov=True --optimizer_momentum=0.9 --optimizer_lr=0.1 --optimizer_weight_decay=1e-4  --total_epochs=60 --training_dataset=TinyImageNetTrain --training_dataset_root=data/tinyimagenet/train --training_key=total_loss --validation_dataset=TinyImageNetValid --validation_dataset_root=data/tinyimagenet/val --validation_keys="[top1,xe]" --validation_keys_minimize="[False,True]" --optimizer_group="{'params': '*decoder*', 'weight_decay': 0.0}" --device=cuda:0 --save=output/ResNet18NCVIBN-TinyImageNet --model_training_samples=2 --model_prior_precision=1e2 --model_var_dampening=1e-1 --loss_vibn_weight=1e-6 --loss_decoder_kld_weight=1e-5 --loss_annealed_iterations=46920 --model_maxpool=True
```

To train ResNet18 NCIDO on CIFAR-10:
```
python main.py --batch_size=128 --loss=ClassificationLossNCVIBN --lr_scheduler=MultiStepLR --lr_scheduler_gamma=0.2 --lr_scheduler_milestones="[60,120,160]" --model=ResNet18NCIDO --model_num_classes=10 --num_workers=4 --optimizer=SGD --optimizer_nesterov=True --optimizer_momentum=0.9 --optimizer_lr=0.1 --optimizer_weight_decay=1e-4  --total_epochs=200 --training_dataset=Cifar10Train --training_dataset_root=data/cifar10 --training_key=total_loss --validation_dataset=Cifar10Valid --validation_dataset_root=data/cifar10 --validation_keys="[top1,xe]" --validation_keys_minimize="[False,True]" --optimizer_group="{'params': '*decoder*', 'weight_decay': 0.0}" --device=cuda:0 --save=output/ResNet18NCIDO-Cifar10 --model_training_samples=2 --model_prior_precision=1e-1 --model_var_dampening=1e-2 --loss_vibn_weight=1e-3 --loss_decoder_kld_weight=2e-5 --loss_annealed_iterations=21120
```

To train ResNet18 NCIDO on CIFAR-100:
```
python main.py --batch_size=128 --loss=ClassificationLossNCVIBN --lr_scheduler=MultiStepLR --lr_scheduler_gamma=0.2 --lr_scheduler_milestones="[60,120,160]" --model=ResNet18NCIDO --model_num_classes=100 --num_workers=4 --optimizer=SGD --optimizer_nesterov=True --optimizer_momentum=0.9 --optimizer_lr=0.1 --optimizer_weight_decay=1e-4  --total_epochs=200 --training_dataset=Cifar100Train --training_dataset_root=data/cifar100 --training_key=total_loss --validation_dataset=Cifar100Valid --validation_dataset_root=data/cifar100 --validation_keys="[top1,xe]" --validation_keys_minimize="[False,True]" --optimizer_group="{'params': '*decoder*', 'weight_decay': 0.0}" --device=cuda:0 --save=output/ResNet18NCIDO-Cifar100 --model_training_samples=2 --model_prior_precision=1e-1 --model_var_dampening=1e-2 --loss_vibn_weight=1e-3 --loss_decoder_kld_weight=2e-5 --loss_annealed_iterations=21120
```

To train ResNet18 NCIDO on Tiny ImageNet:
```
python main.py --batch_size=64 --loss=ClassificationLossNCVIBN --lr_scheduler=MultiStepLR --lr_scheduler_gamma=0.1 --lr_scheduler_milestones="[30,40,50]" --model=ResNet18NCIDO --model_num_classes=200 --num_workers=4 --optimizer=SGD --optimizer_nesterov=True --optimizer_momentum=0.9 --optimizer_lr=0.1 --optimizer_weight_decay=1e-4  --total_epochs=60 --training_dataset=TinyImageNetTrain --training_dataset_root=data/tinyimagenet/train --training_key=total_loss --validation_dataset=TinyImageNetValid --validation_dataset_root=data/tinyimagenet/val --validation_keys="[top1,xe]" --validation_keys_minimize="[False,True]" --optimizer_group="{'params': '*decoder*', 'weight_decay': 0.0}" --device=cuda:0 --save=output/ResNet18NCIDO-TinyImageNet --model_training_samples=2 --model_prior_precision=1e1 --model_var_dampening=1e-1 --loss_vibn_weight=1e-3 --loss_decoder_kld_weight=1e-5  --loss_annealed_iterations=46920 --model_maxpool=True
```

To train ResNet18 NCVIBN-MP on CIFAR-10:
```
python main.py --batch_size=128 --loss=ClassificationLossNCVIBN --lr_scheduler=MultiStepLR --lr_scheduler_gamma=0.2 --lr_scheduler_milestones="[60,120,160]" --model=ResNet18NCVIBNMP --model_num_classes=10 --num_workers=4 --optimizer=SGD --optimizer_nesterov=True --optimizer_momentum=0.9 --optimizer_lr=0.1 --optimizer_weight_decay=1e-4  --total_epochs=200 --training_dataset=Cifar10Train --training_dataset_root=data/cifar10 --training_key=total_loss --validation_dataset=Cifar10Valid --validation_dataset_root=data/cifar10 --validation_keys="[top1,xe]" --validation_keys_minimize="[False,True]" --optimizer_group="{'params': '*decoder*', 'weight_decay': 0.0}" --device=cuda:0 --save=output/ResNet18NCVIBNMP-Cifar10 --model_training_samples=2 --model_prior_precision=1e0 --model_var_dampening=1e-1 --loss_vibn_weight=1e-4 --loss_decoder_kld_weight=2e-5 --loss_annealed_iterations=21120
```

To train ResNet18 NCVIBN-MP on CIFAR-100:
```
python main.py --batch_size=128 --loss=ClassificationLossNCVIBN --lr_scheduler=MultiStepLR --lr_scheduler_gamma=0.2 --lr_scheduler_milestones="[60,120,160]" --model=ResNet18NCVIBNMP --model_num_classes=100 --num_workers=4 --optimizer=SGD --optimizer_nesterov=True --optimizer_momentum=0.9 --optimizer_lr=0.1 --optimizer_weight_decay=1e-4  --total_epochs=200 --training_dataset=Cifar100Train --training_dataset_root=data/cifar100 --training_key=total_loss --validation_dataset=Cifar100Valid --validation_dataset_root=data/cifar100 --validation_keys="[top1,xe]" --validation_keys_minimize="[False,True]" --optimizer_group="{'params': '*decoder*', 'weight_decay': 0.0}" --device=cuda:0 --save=output/ResNet18NCVIBNMP-Cifar100 --model_training_samples=2 --model_prior_precision=1e0 --model_var_dampening=1e-1 --loss_vibn_weight=1e-4 --loss_decoder_kld_weight=2e-5 --loss_annealed_iterations=21120
```

To train ResNet18 NCVIBN-MP on Tiny ImageNet:
```
python main.py --batch_size=64 --loss=ClassificationLossNCVIBN --lr_scheduler=MultiStepLR --lr_scheduler_gamma=0.1 --lr_scheduler_milestones="[30,40,50]" --model=ResNet18NCVIBNMP --model_num_classes=200 --num_workers=4 --optimizer=SGD --optimizer_nesterov=True --optimizer_momentum=0.9 --optimizer_lr=0.1 --optimizer_weight_decay=1e-4  --total_epochs=60 --training_dataset=TinyImageNetTrain --training_dataset_root=data/tinyimagenet/train --training_key=total_loss --validation_dataset=TinyImageNetValid --validation_dataset_root=data/tinyimagenet/val --validation_keys="[top1,xe]" --validation_keys_minimize="[False,True]" --optimizer_group="{'params': '*decoder*', 'weight_decay': 0.0}" --device=cuda:0 --save=output/ResNet18NCVIBNMP-TinyImageNet --model_training_samples=2 --model_prior_precision=1e0 --model_var_dampening=1e-1 --loss_vibn_weight=1e-5 --loss_decoder_kld_weight=1e-5 --loss_annealed_iterations=46920 --model_maxpool=True
```

To train ResNet50 LLNCVIBN on ImageNet:
```
python main.py --batch_size=256 --loss=ClassificationLoss --lr_scheduler=MultiStepLR --lr_scheduler_gamma=0.1 --lr_scheduler_milestones="[30,60,80]" --model=ResNet50 --model_num_classes=1000 --num_workers=4 --optimizer=SGD --optimizer_nesterov=True --optimizer_momentum=0.9 --optimizer_lr=0.1 --optimizer_weight_decay=1e-4  --total_epochs=90 --training_dataset=ImageNetTrain --training_dataset_root=data/imagenet/train --training_key=xe --validation_dataset=ImageNetValid --validation_dataset_root=data/imagenet/val --validation_keys="[top1,xe]" --validation_keys_minimize="[False,True]" --device=cuda:0 --save=output/ResNet50-ImageNet
```

To train ResNet50 LLNCVIBN on ImageNet:
```
python main.py --batch_size=256 --loss=ClassificationLossNCVIBN --lr_scheduler=MultiStepLR --lr_scheduler_gamma=0.1 --lr_scheduler_milestones="[30,60,80]" --model=ResNet50LLNCVIBN --model_num_classes=1000 --num_workers=4 --optimizer=SGD --optimizer_nesterov=True --optimizer_momentum=0.9 --optimizer_lr=0.1 --optimizer_weight_decay=1e-4  --total_epochs=90 --training_dataset=ImageNetTrain --training_dataset_root=data/imagenet/train --training_key=total_loss --validation_dataset=ImageNetValid --validation_dataset_root=data/imagenet/val --validation_keys="[top1,xe]" --validation_keys_minimize="[False,True]" --optimizer_group="{'params': '*decoder*', 'weight_decay': 0.0}" --device=cuda:0 --save=output/ResNet50LLNCVIBN-ImageNet --model_training_samples=2 --model_prior_precision=1e1 --model_var_dampening=1e-3 --loss_vibn_weight=1e-5 --model_gamma=0.75 --loss_decoder_kld_weight=1e-6 --loss_annealed_iterations=150150 --model_maxpool=True
```


### Test commands

To test ResNet18 on CIFAR-10:
```
python evaluate_uncertainty.py --filename=ResNet18-Cifar10.ckpt --net=ResNet18 --num_classes=10 --dataset=Cifar10Test --dataset_path=data/cifar10
```

To test ResNet18 on CIFAR-100:
```
python evaluate_uncertainty.py --filename=ResNet18-Cifar100.ckpt --net=ResNet18 --num_classes=100 --dataset=Cifar100Test --dataset_path=data/cifar100
```

To test ResNet18 on Tiny ImageNet:
```
python evaluate_uncertainty.py --filename=ResNet18-TinyImageNet.ckpt --net=ResNet18 --num_classes=200 --dataset=TinyImageNetValid --dataset_path=data/tinyimagenet/val --maxpool=True
```

To test ResNet18 VIBN on CIFAR-10:
```
python evaluate_uncertainty.py --filename=ResNet18VIBN-Cifar10.ckpt --net=ResNet18 --mode=VIBN --num_classes=10 --dataset=Cifar10Test --dataset_path=data/cifar10
```

To test ResNet18 VIBN on CIFAR-100:
```
python evaluate_uncertainty.py --filename=ResNet18VIBN-Cifar100.ckpt --net=ResNet18 --mode=VIBN --num_classes=100 --dataset=Cifar100Test --dataset_path=data/cifar100
```

To test ResNet18 VIBN on Tiny ImageNet:
```
python evaluate_uncertainty.py --filename=ResNet18VIBN-TinyImageNet.ckpt --net=ResNet18 --mode=VIBN --num_classes=200 --dataset=TinyImageNetValid --dataset_path=data/tinyimagenet/val --maxpool=True
```

To test ResNet18 IDO on CIFAR-10:
```
python evaluate_uncertainty.py --filename=ResNet18IDO-Cifar10.ckpt --net=ResNet18 --mode=IDO --num_classes=10 --dataset=Cifar10Test --dataset_path=data/cifar10
```

To test ResNet18 IDO on CIFAR-100:
```
python evaluate_uncertainty.py --filename=ResNet18IDO-Cifar100.ckpt --net=ResNet18 --mode=IDO --num_classes=100 --dataset=Cifar100Test --dataset_path=data/cifar100
```

To test ResNet18 IDO on Tiny ImageNet:
```
python evaluate_uncertainty.py --filename=ResNet18IDO-TinyImageNet.ckpt --net=ResNet18 --mode=IDO --num_classes=200 --dataset=TinyImageNetValid --dataset_path=data/tinyimagenet/val --maxpool=True
```

To test ResNet18 VIBNMP on CIFAR-10:
```
python evaluate_uncertainty.py --filename=ResNet18VIBNMP-Cifar10.ckpt --net=ResNet18 --mode=VIBNMP --num_classes=10 --dataset=Cifar10Test --dataset_path=data/cifar10
```

To test ResNet18 VIBNMP on CIFAR-100:
```
python evaluate_uncertainty.py --filename=ResNet18VIBNMP-Cifar100.ckpt --net=ResNet18 --mode=VIBNMP --num_classes=100 --dataset=Cifar100Test --dataset_path=data/cifar100
```

To test ResNet18 VIBNMP on Tiny ImageNet:
```
python evaluate_uncertainty.py --filename=ResNet18NCVIBNMP-TinyImageNet.ckpt --net=ResNet18 --mode=VIBNMP --num_classes=200 --dataset=TinyImageNetValid --dataset_path=data/tinyimagenet/val --maxpool=True
```

To test ResNet18 NCVIBN on CIFAR-10:
```
python evaluate_uncertainty.py --filename=ResNet18NCVIBN-Cifar10.ckpt --net=ResNet18 --mode=NCVIBN --num_classes=10 --dataset=Cifar10Test --dataset_path=data/cifar10
```

To test ResNet18 NCVIBN on CIFAR-100:
```
python evaluate_uncertainty.py --filename=ResNet18NCVIBN-Cifar100.ckpt --net=ResNet18 --mode=NCVIBN --num_classes=100 --dataset=Cifar100Test --dataset_path=data/cifar100
```

To test ResNet18 NCVIBN on Tiny ImageNet:
```
python evaluate_uncertainty.py --filename=ResNet18NCVIBN-TinyImageNet.ckpt --net=ResNet18 --mode=NCVIBN --num_classes=200 --dataset=TinyImageNetValid --dataset_path=data/tinyimagenet/val --maxpool=True
```

To test ResNet18 NCIDO on CIFAR-10:
```
python evaluate_uncertainty.py --filename=ResNet18NCIDO-Cifar10.ckpt --net=ResNet18 --mode=NCIDO --num_classes=10 --dataset=Cifar10Test --dataset_path=data/cifar10
```

To test ResNet18 NCIDO on CIFAR-100:
```
python evaluate_uncertainty.py --filename=ResNet18NCIDO-Cifar100.ckpt --net=ResNet18 --mode=NCIDO --num_classes=100 --dataset=Cifar100Test --dataset_path=data/cifar100
```

To test ResNet18 NCIDO on Tiny ImageNet:
```
python evaluate_uncertainty.py --filename=ResNet18NCIDO-TinyImageNet.ckpt --net=ResNet18 --mode=NCIDO --num_classes=200 --dataset=TinyImageNetValid --dataset_path=data/tinyimagenet/val --maxpool=True
```

To test ResNet18 NCVIBNMP on CIFAR-10:
```
python evaluate_uncertainty.py --filename=ResNet18NCVIBNMP-Cifar10.ckpt --net=ResNet18 --mode=NCVIBNMP --num_classes=10 --dataset=Cifar10Test --dataset_path=data/cifar10
```

To test ResNet18 NCVIBNMP on CIFAR-100:
```
python evaluate_uncertainty.py --filename=ResNet18NCVIBNMP-Cifar100.ckpt --net=ResNet18 --mode=NCVIBNMP --num_classes=100 --dataset=Cifar100Test --dataset_path=data/cifar100
```

To test ResNet18 NCVIBNMP on Tiny ImageNet:
```
python evaluate_uncertainty.py --filename=ResNet18NCVIBNMP-TinyImageNet.ckpt --net=ResNet18 --mode=NCVIBNMP --num_classes=200 --dataset=TinyImageNetValid --dataset_path=data/tinyimagenet/val --maxpool=True
```

To test ResNet50 on ImageNet:
```
python evaluate_uncertainty.py --filename=ResNet50-ImageNet.ckpt --net=ResNet50 --num_classes=1000 --dataset=ImageNetValid --dataset_path=data/imagenet/val --maxpool=True
```

To test ResNet50 LLNCVIBN on ImageNet:
```
python evaluate_uncertainty.py --filename=ResNet50LLNCVIBN-ImageNet.ckpt --net=ResNet50 --mode=LLNCVIBN --num_classes=1000 --dataset=ImageNetValid --dataset_path=data/imagenet/val --maxpool=True --gamma=0.75
```