from __future__ import annotations

from typing import Callable, Optional

import numpy as np

from src.algorithms.DAL_CBs import DALContext
from src.core.bandit import BanditAlgorithm
from src.core.detection import detect_change_gsr


class DALContextGSR(DALContext):

    def __init__(
        self,
        T: int,
        delta: float,
        noise_variance: float,
        *,
        base_factory: Callable[[], BanditAlgorithm],
        rng: Optional[np.random.Generator] = None,
        explore_coef: float = 1e-3,
        change_detector: Optional[Callable[..., bool]] = None,
    ):
        super().__init__(
            T,
            delta,
            noise_variance,
            base_factory=base_factory,
            rng=rng,
            explore_coef=explore_coef,
            change_detector=change_detector or detect_change_gsr,
        )


__all__ = ["DALContextGSR"]
