from __future__ import annotations

from typing import Any, Dict, Optional, Callable

from src.algorithms.DAL_SCB import DAL_SCB
from src.core.bandit import BanditAlgorithm
from src.core.detection import detect_change_gsr


class DAL_SCB_GSR(DAL_SCB):

    def __init__(
        self,
        T: int,
        delta: float,
        *,
        base_factory=None,
        base_kwargs: Optional[Dict[str, Any]] = None,
        base_algorithm: Optional[BanditAlgorithm] = None,
        detector: Optional[Callable[..., bool]] = None,
    ):
        super().__init__(
            T,
            delta**0.5,
            base_factory=base_factory,
            base_kwargs=base_kwargs,
            base_algorithm=base_algorithm,
            detector=detector or detect_change_gsr,
        )


__all__ = ["DAL_SCB_GSR"]
