from abc import ABC, abstractmethod
import numpy as np
import sympy as sp


import numpy as np

def find_independent_vectors(vectors, d=None):
    if len(vectors) == 0:
        return []

    n = len(vectors[0])
    if d is None:
        d = n

    norms = [np.linalg.norm(v) for v in vectors]
    sorted_idxs = sorted(range(len(vectors)), key=lambda i: norms[i], reverse=True)

    indep_vecs = []
    indep_indices = []

    for idx in sorted_idxs:
        v = vectors[idx]
        if not indep_vecs:
            indep_vecs.append(v)
            indep_indices.append(idx)
        else:
            M = np.vstack(indep_vecs + [v])
            if np.linalg.matrix_rank(M) == len(indep_vecs) + 1:
                indep_vecs.append(v)
                indep_indices.append(idx)

        if len(indep_vecs) >= d:
            break

    return indep_indices




class BanditAlgorithm(ABC):
    def __init__(self, num_actions, horizon):
        self.num_actions = num_actions
        self.T = horizon
        self.all_arms = []
        self.rewards = []
        self.ChangePoints =[]
        self.t = 0
        self.is_reset=False
        self.indep_arms=None

    @abstractmethod
    def select_arm(self, arms):
        pass

    @abstractmethod
    def update_statistics(self, arm, reward):
        pass

    def get_indep_arms(self):
        mat=np.array(self.all_arms)
        _, inds = sp.Matrix(mat).T.rref()

        self.indep_arm_inds=inds
        self.indep_arms=[self.all_arms[i] for i in inds]
        self.N_e=len(self.indep_arms)
    def update(self, arm, reward):
        self.update_statistics(arm, reward)
        if(self.is_reset):
            self.is_reset=False
        else:
            self.t += 1

    def re_init(self):
        self.arms = []
        self.rewards = []
        self.t = 0
        self.is_reset=True

