import argparse
import json

def opts():
    parser = argparse.ArgumentParser(description='SKAR', formatter_class=argparse.ArgumentDefaultsHelpFormatter)
    # datasets
    parser.add_argument('--data_path', type=str, default='./data/datasets/', help='root of source training set')
    parser.add_argument('--data_path_source', type=str, default='', help='set automatically by data_path value.')
    parser.add_argument('--data_path_target', type=str, default='', help='set automatically by data_path value.')
    parser.add_argument('--data_path_target_t', type=str, default='', help='set automatically by data_path value.')
    parser.add_argument('--src', type=str, default='amazon', help='source training set')
    parser.add_argument('--tar', type=str, default='dslr', help='target training set')
    parser.add_argument('--tar_t', type=str, default=None, help='target test set')
    parser.add_argument('--num_classes', type=int, default=31, help='class number')
    parser.add_argument('--src_soft_select', action='store_true', help='placeholder')
    parser.add_argument('--src_hard_select', action='store_true', help='placeholder')
    parser.add_argument('--src_mix_weight', action='store_true', help='placeholder')
    parser.add_argument('--tao_param', type=float, default=0.5, help='placeholder')
    parser.add_argument('--max', type=int, default=200, help='placeholder')    
    parser.add_argument('--batch_size', '--bs', type=int, default=32, help='batch size')
    parser.add_argument('--workers', type=int, default=8, metavar='N', help='number of data loading workers (default: 8)')
    parser.add_argument('--no_da', action='store_true', help='placeholder')
    parser.add_argument('--lr', type=float, default=1e-2, help='learning rate')
    parser.add_argument('--lr_plan', type=str, default='dao', help='placeholder')
    parser.add_argument('--schedule', type=int, nargs='+', default=[], help='placeholder')
    parser.add_argument('--momentum', type=float, default=0.9, help='momentum')
    parser.add_argument('--weight_decay', type=float, default=1e-4, help='weight decay (L2 penalty)')
    parser.add_argument('--nesterov', action='store_true', help='whether to use nesterov SGD')
    parser.add_argument('--eps', type=float, default=1e-6, help='a small value to prevent underflow')
    parser.add_argument('--ao', action='store_true', help='placeholder')
    parser.add_argument('--cluster_method', type=str, default='kmeans', help='placeholder')
    parser.add_argument('--cluster_iter', type=int, default=5, help='placeholder')
    parser.add_argument('--cluster_kernel', type=str, default='rbf', help='placeholder')
    parser.add_argument('--gamma', type=float, default=None, help='placeholder')
    parser.add_argument('--sample_weight', action='store_true', help='placeholder')
    parser.add_argument('--initial_cluster', type=int, default=1, help='placeholder')
    parser.add_argument('--init_cen_on', default='t', help='placeholder')
    parser.add_argument('--src_cen_first', action='store_true', help='placeholder')
    parser.add_argument('--src_cls', action='store_true', help='placeholder')
    parser.add_argument('--src_fit', action='store_true', help='placeholder')
    parser.add_argument('--src_pretr_first', action='store_true', help='placeholder')
    parser.add_argument('--learn_embed', action='store_true', help='placeholder')
    parser.add_argument('--no_second_embed', action='store_true', help='placeholder')
    parser.add_argument('--alpha', type=float, default=1.0, help='placeholder')
    parser.add_argument('--beta', type=float, default=1.0, help='placeholder')
    parser.add_argument('--embed_softmax', action='store_true', help='placeholder')
    parser.add_argument('--div', type=str, default='kl', help='placeholder')
    parser.add_argument('--gray_tar_agree', '--gta', action='store_true', help='whether to enforce the consistency between RGB and gray images on the target domain')
    parser.add_argument('--aug_tar_agree', '--ata', action='store_true', help='placeholder')
    parser.add_argument('--sigma', type=float, default=0.1, help='standard deviation of Gaussian for data augmentation operation of blurring')
    # checkpoints
    parser.add_argument('--resume', type=str, default='', help='placeholder')
    parser.add_argument('--log', type=str, default='./results/office31', help='log folder')
    parser.add_argument('--stop_epoch', type=int, default=200, metavar='N', help='stop epoch for early stop (default: 200)')
    # architecture
    parser.add_argument('--arch', type=str, default='resnet50', help='model name')
    parser.add_argument('--num_neurons', type=int, default=128, help='number of neurons of fc1')
    parser.add_argument('--pretrained', action='store_true', help='whether to use pretrained model')
    # i/o
    parser.add_argument('--print_freq', type=int, default=20, metavar='N', help='print frequency (default: 20)')
    # custom
    parser.add_argument('--learn_cen_mode', '--lcm', default='non_learnable', help='placeholder')
    parser.add_argument('--tar_loss_idx', type=int, default=0, help='idx of target loss name in loss_list in trainer.py file')
    parser.add_argument('--aug_cons_layers', type=int, default=[], nargs='+', help='placeholder')
    parser.add_argument('--test_it', action='store_true', help='placeholder')
    parser.add_argument('--learn_emb_ofsee', action='store_true', help='placeholder')
    parser.add_argument('--nearing_aug_es_layers', type=int, default=[], nargs='+', help='placeholder')
    parser.add_argument("--config", type=str, default="args.json", help='placeholder')
    parser.add_argument('--aug_dup_idx', '--aug_d_i', type=int, default=0, help='placeholder')
    parser.add_argument('--aug_gray_idx', '--aug_g_i', type=int, default=1, help='idx the second augmentation using for self-supervised loss')
    parser.add_argument('--gpu_indices', type=int, default=[0], nargs='+', help='list of indices of gpus which must be used')
    parser.add_argument('--cons_loss_weight_one', action='store_true', help='placeholder')
    parser.add_argument('--label_smoothing', '--ls', type=float, default=0.2, help='label smoothing parameter between 0 to 1. if being 0 then naive cross entropy will be applied')
    parser.add_argument('--dont_learn_embed', '--dle', action='store_true', help='placeholder')
    parser.add_argument('--lr_min', type=float, default=0.0, help='placeholder')
    parser.add_argument('--new_rand_method', '--nrm', action='store_true', help='whether to use new randomness method')
    parser.add_argument('--seed', type=int, default=1, help='random seed')
    parser.add_argument("--optimizer", type=str, default="SGD", help='placeholder')
    parser.add_argument("--lambda_method", type=str, default="inv_dao", help='placeholder')
    parser.add_argument('--aug_denom', type=float, default=1.0, help='placeholder')
    parser.add_argument('--src_aug_idx', type=int, default=0, help='idx of augmentation of the source train data')
    parser.add_argument('--save_final', action='store_true', help='placeholder')
    parser.add_argument('--resize_to_square', action='store_true', help='placeholder')
    parser.add_argument("--rtsquare_intpl", type=str, default=None, help='placeholder')
    parser.add_argument('--a1', type=float, default=0.5, help='coefficient of adaptation loss term')
    parser.add_argument('--a2', type=float, default=0.5, help='coefficient of regularization loss term')
    parser.add_argument('--a3', type=float, default=0.5, help='coefficient of self-supervised loss term')
    parser.add_argument('--nclayers', type=int, default=2, help='placeholder')
    parser.add_argument('--nrmfr', action='store_true', help='placeholder')
    parser.add_argument('--ssbtconst', action='store_true', help='placeholder')
    parser.add_argument('--tlsmooth', type=float, default=None, help='placeholder')
    parser.add_argument('--no_pretrain', action='store_true', help='not to use pretrain model')
    parser.add_argument('--base_aug_idx', '--bai', type=int, default=None, help='idx of the base target augmentation')
    parser.add_argument('--test_trans_idx', '--tti', type=int, default=None, help='idx of the target test data transform')
    parser.add_argument("--ns", type=str, default='imagenet', help="What domain should be used for normalization statistics")
    parser.add_argument('--source_test_trans_idx', '--stti', type=int, default=None, help='idx of the source test data transform')

    args = parser.parse_args()
    # setting constant arguments
    args.init_cen_on = 's'
    args.tar_loss_idx = 6
    args.gray_tar_agree = True
    args.learn_cen_mode = 'non_learnable'
    args.learn_emb_ofsee = True
    args.dont_learn_embed = True
    args.new_rand_method = True
    args.rtsquare_intpl = 'bilinear'
    args.save_final = True
    # setting source and target paths
    args.data_path_source = args.data_path
    args.data_path_target = args.data_path
    args.data_path_target_t = args.data_path
    if args.tar_t == None:
        args.tar_t = args.tar
    args_dict = vars(args)

    try:
        args.batch_size = int(args.bs)
    except AttributeError:
        pass
    try:
        args.new_rand_method = args.nrm
    except AttributeError:
        pass
    try:
        args.aug_dup_idx = int(args.aug_d_i)
    except AttributeError:
        pass
    try:
        args.aug_gray_idx = int(args.aug_g_i)
    except AttributeError:
        pass
    try:
        args.dont_learn_embed = args.dle
    except AttributeError:
        pass
    try:
        args.gray_tar_agree = args.gta
    except AttributeError:
        pass
    try:
        args.aug_tar_agree = args.ata
    except AttributeError:
        pass
    try:
        args.base_aug_idx = int(args.bai)
    except AttributeError:
        pass
    try:
        args.test_trans_idx = int(args.tti)
    except AttributeError:
        pass
    try:
        args.label_smoothing = float(args.ls)
    except AttributeError:
        pass
    try:
        args.learn_cen_mode = args.lcm
    except AttributeError:
        pass
    try:
        args.source_test_trans_idx = int(args.stti)
    except AttributeError:
        pass
    
    if args.nrmfr:
        args.new_rand_method = args.nrmfr
    if args.tlsmooth == None:
        args.tlsmooth = args.label_smoothing
    if args.learn_cen_mode == 'nl':
        args.learn_cen_mode = 'non_learnable'
    if args.source_test_trans_idx == None:
        args.source_test_trans_idx = args.test_trans_idx

    if args.no_pretrain:
        args.pretrained = False
    else:
        args.pretrained = True
    
    args.src_cls = True
    args.src_cen_first = True
    args.learn_embed = True
    args.embed_softmax = True
    if args.dont_learn_embed:
        args.learn_embed = False
    args.log = args.log + 'adapt_' + args.src + '2' + args.tar + '_' + args.arch

    if args.new_rand_method and args.seed == -1:
        print(args.seed)
        parser.error("When new_rand_method is True then seed must not be -1.")
    if not args.new_rand_method and args.seed != -1:
        parser.error("When new_rand_method is False then seed argument does not effect.")
    if args.resize_to_square and args.rtsquare_bilinear:
        parser.error("Only one of .")
    print(vars(args))
    return args

def load_config(file_path):
    try:
        with open(file_path, "r") as f:
            return json.load(f)
    except (FileNotFoundError, json.JSONDecodeError) as e:
        print(f"Warning: Could not load config file '{file_path}': {e}")
        return {}