# SIMSHIFT: A Benchmark for Adapting Neural Surrogates to Distribution Shifts

[![License: MIT](https://img.shields.io/badge/License-MIT-blue.svg)](LICENSE)

## Overview

This repository contains the datasets, dataloaders, baseline models and domain adatpation algorithms and model selection strategies together with evaluation protocols for **SIMSHIFT**, a benchmark designed to evaluate Unsupervised Domain Adaptation (UDA) methods for neural surrogates of physical simulations. The benchmark's datasets target real world industrial scenarios and provides distribution shifts across parameter configurations in mesh-based PDE simulations.

**Datasets:**

- **Hot rolling**
- **Sheet metal forming**
- **Electric motor design**
- **Heatsink desing**

This is the official repository to the [NeurIPS Datasets and Benchmark Track Submission](https://openreview.net/forum?id=Eo4cRmb1yn&noteId=Eo4cRmb1yn).

### 1. Installation

Clone the repo and choose/create a virtual environment (tested with python 3.11)  create a virtual environment, and check out your inin:

```bash
git clone <path_to_repo_upon_publication>
cd simshift
```

Create a new virual environment (the code was developed and tested with python 3.11) and install the required dependencies:
```
conda create -n simshift python=3.11
conda activate simshift
```

First please install you desired torch version (the repo was tested with torch 2.5.1), as shown [here](https://pytorch.org/get-started/locally/).

This project uses [PyTorch Geometric (PyG)](https://pytorch-geometric.readthedocs.io/), which requires a few core packages to be installed from custom wheels depending on your PyTorch and CUDA version.

We **do not include** the following packages in `requirements.txt` due to compatibility constraints:

- `torch_geometric`
- `torch-cluster`
- `torch-scatter`

To install them manually, first check your PyTorch and CUDA version:

```bash
python -c "import torch; print(f'PyTorch {torch.__version__}, CUDA {torch.version.cuda}')"
```

And then install the packages above accordingly.

Finally, install the other required packages with:

```
pip install -r requirements.txt
```

#### 2. Tutorial notebooks

To get familiar with the capabilities of this repository, we provide a [tutorial notebook](./notebooks/tutorial.ipynb) showing easy model training and result evaluation and visualization.

#### 3. Paper results reproduciblility

In order to provide maximum transparency, we provide clear instructions on we obtained the papers results [here](./results/README.md).
