#!/usr/bin/env bash
num_workers=1
epochs=5000
eval_epochs=100

dim=2048
pred_dim=256

python main.py --method diet --dataset CIFAR10 -a resnet18\
        --num_targets 0 --target_layers 1  --pred_layers 2 --warmup_epochs 10\
        --dim $dim --pred_dim $pred_dim --loss ce-smooth\
        -j $num_workers --epochs $epochs -b 512 --lr 0.001\
        --optimizer-type adamw --momentum 0.9 --wd 0.05\
        --eval_epochs $eval_epochs --eval_lr 0.2 --eval_bs 512\
        --num-of-runs 1 --eval_freq 500 --save_freq 5000 --eval_during_ssl_training