#!/usr/bin/env bash
num_workers=1
epochs=800
eval_epochs=100

dim=2048
pred_dim=256

python main.py --method simsiam --dataset CIFAR10 -a resnet18\
        --num_targets 0 --pred_layers 2 --target_layers 1\
        --dim $dim --pred_dim $pred_dim --loss cosine\
        -j $num_workers --epochs $epochs -b 512 --lr 0.03\
        --optimizer-type sgd --momentum 0.9 --wd 5e-4\
        --eval_epochs $eval_epochs --eval_lr 0.2 --eval_bs 512\
        --num-of-runs 1 --eval_freq 80 --save_freq 800 --eval_during_ssl_training