
# Replication Code for TabCascade

## Install

Make sure `uv` is installed and run `uv sync`.
In addition, we need to install the R package `disttree` for the distributional tree encoder.
In theory, running experiments/model/lowres/disttree.py should be enough and automatically install the package. However, for some systems, custom steps may be needed dependent on your R installation (if already installed locally) and its interaction with `rpy2`.

## Running scripts

All configuration files are located in experiments/configs.
To replicate the experiments run from project root:
`uv run main.py $DATA experiments/configs/$MODEL/default.yaml train $SEED -miss_mechanism=mnar --exp_path=${MODEL}_${SEED}`

Available MODELs:
- arf
- ctgan
- tvae
- tabddpm
- tabsyn
- tabdiff
- cdtd
- tabcascade (default.yaml and default_gmm.yaml)

Seeds used in the paper are 0, 42, 86.

Use the `train` option to train the model and switch to `eval` to evaluate an already trained model.

