

import torch
import torch.nn as nn
import torch.nn.functional as F


class VanilaMLP(nn.Module):
    def __init__(self, input_dim=38, hidden_dim=64):
        super(VanilaMLP, self).__init__()

        self.hidden_dim = hidden_dim
        self.input_dim = input_dim
        self.n_class = 1
        self.fc1 = nn.Linear(self.input_dim, self.hidden_dim, bias=True)
        self.fc2 = nn.Linear(self.hidden_dim, self.hidden_dim, bias=True)
        self.fc3 = nn.Linear(self.hidden_dim, self.hidden_dim//2, bias=True)
        self.fc4 = nn.Linear(self.hidden_dim//2, 1, bias=False)

    def forward(self, x):
        x = F.leaky_relu(self.fc1(x))
        x = F.leaky_relu(self.fc2(x))
        feature = self.fc3(x)
        x = F.leaky_relu(feature)
        x = self.fc4(x)
        return x

