import os

from sklearn.neighbors import KernelDensity

import numpy as np
import matplotlib.pyplot as plt

from scipy.special import softmax

import torch


def min_max_standardize(data):
    min_val = np.min(data)
    max_val = np.max(data)
    
    # Rescale the data to [0, 1]
    standardized_data = (data - min_val) / (max_val - min_val + 1e-9)
 
    return standardized_data

def median_standardize(data):
    median_val = np.median(data)
    standardized_data = (data - median_val) / (median_val + 1e-9)
    return standardized_data


if __name__ == "__main__":
    files = os.listdir('./data')

    xs = []
    ys = []
    ranges = []
    for f in files:
        save = torch.load('./data' + '/' + f)

##        aucs = min_max_standardize(save['aucs'])
        aucs = save['aucs']
        scores = save['train_scores']

        for i, s in enumerate(scores):
##            s = median_standardize(s)

            s = softmax(s)
            
            kde = KernelDensity(kernel='gaussian', bandwidth=0.1)
            kde.fit(s.reshape(-1, 1))

            min_val = np.min(s)
            max_val = np.max(s)
            x = np.linspace(0, 1, 1000)
            # x = np.linspace(np.min(s), np.max(s), 1000)
            dens = np.exp(kde.score_samples(x.reshape(-1, 1)))

            xs.append(dens)
            ys.append(aucs[i])
            ranges.append((min_val, max_val))

    torch.save({'x': np.stack(xs),
                'y': np.array(ys),
                'range': ranges}, './kde_auc_data_softmax-no_pos.tar')
    
