import copy

import numpy as np
import matplotlib.pyplot as plt

from sklearn.metrics import roc_auc_score
from sklearn.neighbors import KernelDensity

from astropy.visualization import hist
from scipy.stats import wasserstein_distance
from scipy.special import softmax

from scipy.stats import levy_stable, cauchy, fisk, weibull_min, burr, pareto, chi2

import torch
import pyod
##from pyod.models import iforest
##from pyod.models import copod
##from pyod.models import auto_encoder
##from pyod.models import knn
##from pyod.models import lof
from pyod.models import deep_svdd
##from pyod.models import anogan
##from pyod.models import ecod

from pyod.models import ocsvm

from dataset import shallow_method_data_loader as data_loader

import optuna


from BO_Objective import Objective


if __name__ == "__main__":
    datasets = [
        # '5_campaign', '8_celeba', '9_census', '11_donors', '13_fraud', '16_http',  # discarded
        # '32_shuttle', '33_skin','34_smtp', '10_cover' # discarded
        # '3_backdoor',  # large


        '48_arrhythmia',
        '15_Hepatitis', '45_wine', '42_WBC', '46_WPBC', '43_WDBC', '18_Ionosphere',
        '21_Lymphography', '14_glass', '37_Stamps', '39_vertebral',
        '4_breastw', '29_Pima', '49_shuttle',

        # '17_InternetAds', '19_landsat',
        # '20_letter', '24_mnist',
        # '40_vowels', '41_Waveform'
        # '38_thyroid',
        # '12_fault',
        # '25_musk', '26_optdigits', '27_PageBlocks', '28_pendigits', '2_annthyroid',
        # '30_satellite', '31_satimage-2', '35_SpamBase',
        # '36_speech', '44_Wilt',
        # '7_Cardiotocography',
        # # '22_magic.gamma',
        # '23_mammography',
        # '1_ALOI',  # mid
                ]
    for dataset in datasets:
        for method in ['generated', 'relative-topk-median', 'avg-var-20-k', 'EM']:
            for n_noise in [0]:
                for k in [0.05]:
                    if method in ['wasserstein', 'kde-wasserstein', 'kde-kl', 'kde-wasserstein-v2', 'kde-l2', 'EM']:
                        direction = 'minimize'
                        # temp_name = 'None'
                    else:
                        direction = 'maximize'
                    temp_name = 'New2'

                    objective = Objective(dataset, objective='delta', k=k, n_noise=n_noise, method=method,
                                          temp_name=temp_name, save_path='./res', permutation_seed=0)

                    algo = optuna.samplers.TPESampler(n_startup_trials=10, n_ei_candidates=24)
                    # algo = optuna.samplers.GPSampler(n_startup_trials=10)
                    study = optuna.create_study(sampler=algo, direction=direction,
                                                # storage="sqlite:///record/dpad2.db"
                                                )
                    study.optimize(objective.drocc_search, n_trials=500, show_progress_bar=True)
                    print(study.best_trial)

                    objective.plot_results('DROCC', root='./res')
                    objective.save_result('DROCC')

    

    
