import copy

import numpy as np
import matplotlib.pyplot as plt

from sklearn.metrics import roc_auc_score
from sklearn.neighbors import KernelDensity

from astropy.visualization import hist
from scipy.stats import wasserstein_distance
from scipy.special import softmax

from scipy.stats import levy_stable, cauchy, fisk, weibull_min, burr, pareto, chi2

import torch
import pyod
##from pyod.models import iforest
##from pyod.models import copod
##from pyod.models import auto_encoder
##from pyod.models import knn
##from pyod.models import lof
from pyod.models import deep_svdd
##from pyod.models import anogan
##from pyod.models import ecod

from pyod.models import ocsvm

from dataset import shallow_method_data_loader as data_loader

import optuna


from BO_Objective import Objective


if __name__ == "__main__":
    datasets = [
        '4_breastw',
        # '45_wine',
        # '12_fault',
        # '48_arrhythmia',
        # '14_glass',
        # '15_Hepatitis',
        # '20_letter', '21_Lymphography',
        # # '22_magic.gamma', '23_mammography',
        # '24_mnist',
        # # # '25_musk', '26_optdigits',
        # '42_WBC',
        # '46_WPBC',
        # '29_Pima', '38_thyroid', '39_vertebral',
        # '47_yeast', '41_Waveform'
                ]
    for dataset in datasets:
        for method in ['otsu-max-ind', 'avg-var-20-k']:
            for n_noise in [0]:
                for k in [0.05]:
                    if method in ['wasserstein', 'kde-wasserstein']:
                        direction = 'minimize'
                        temp_name = 'handcraft'
                    else:
                        direction = 'maximize'
                        temp_name = 'None2'

                    objective = Objective(dataset, objective='delta', k=k, n_noise=n_noise, method=method, temp_name=temp_name)

                    algo = optuna.samplers.TPESampler(n_startup_trials=10, n_ei_candidates=24)
                    study = optuna.create_study(sampler=algo, direction=direction, storage="sqlite:///record/ocsvm2.db")
                    study.optimize(objective.ae_search, n_trials=500, show_progress_bar=True)
                    print(study.best_trial)

                    objective.plot_results('AE', root='./res-0905')
                    objective.save_result('AE')

    

    
