# Neural Transformation Learning for Anomaly Detection (NeuTraLAD) - a self-supervised method for anomaly detection
# Copyright (c) 2022 Robert Bosch GmbH
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.
#

import argparse
from config.base import Grid, Config
from evaluation.Experiments import runExperiment
from evaluation.Kvariants_Eval import KVariantEval

def get_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('--config-file', dest='config_file', default='config_thyroid.yml')
    parser.add_argument('--dataset-name', dest='dataset_name', default='thyroid')
    return parser.parse_args()

def EndtoEnd_Experiments(config_file, dataset_name):

    model_configurations = Grid(config_file, dataset_name)
    model_configuration = Config(**model_configurations[0])
    dataset =model_configuration.dataset
    result_folder = model_configuration.result_folder+model_configuration.exp_name
    exp_class = runExperiment
    risk_assesser = KVariantEval(dataset, result_folder, model_configurations)

    risk_assesser.risk_assessment(exp_class)

if __name__ == "__main__":
    # args = get_args()
    # config_file = 'config_files/'+args.config_file
    config_file = './config_files/config_thyroid.yml'
    for dataset_name in ['45_wine', '10_cover', '11_donors', '12_fault', '13_fraud', '14_glass', '15_Hepatitis', '16_http',
                '17_InternetAds', '18_Ionosphere', '19_landsat',
                '1_ALOI', '20_letter', '21_Lymphography', '22_magic.gamma', '23_mammography', '24_mnist',
                '25_musk', '26_optdigits', '27_PageBlocks', '28_pendigits', '29_Pima', '2_annthyroid',
                '30_satellite', '31_satimage-2', '32_shuttle', '33_skin', '34_smtp', '35_SpamBase', '36_speech',
                '37_Stamps', '38_thyroid', '39_vertebral', '3_backdoor', '40_vowels', '41_Waveform', '42_WBC',
                '43_WDBC', '44_Wilt', '46_WPBC', '47_yeast', '4_breastw', '5_campaign', '6_cardio',
                '7_Cardiotocography', '8_celeba', '9_census', '48_arrhythmia']:
        print(dataset_name)
        EndtoEnd_Experiments(config_file, dataset_name)
