import os
import copy
import json

import numpy as np
import pandas as pd


def read_dpad_save_(f_name):
    f_name_l = f_name.split('\\')
    method = 'NeuTraLAD'
    dataset = f_name_l[-3].split('_')[1]
    cls = f_name_l[-2].split('_')[0]
    num_run = 0
    if not cls.isdigit():
##        print(f_name)
        return None
    with open(f_name, 'r') as f:
        save_ = json.load(f)
    try:
        save = {}
        save['dataset'] = dataset
        save['class'] = cls
        save['methods'] = method
        save['num_run'] = num_run
        save['avg_auroc'] = np.mean(save_['TS_AUC'])
        save['std_auroc'] = np.std(save_['TS_AUC'])
        save['avg_f1'] = np.mean(save_['TS_F1'])
        save['std_f1'] = np.std(save_['TS_F1'])
    except:
        print(f_name)
        return
    return save


def read_dpad_save(f_name):
    f_name_l = f_name.split('\\')
    method = 'NeuTraLAD'
    dataset = '_'.join(f_name_l[-3].split('_')[1:3])
    cls = f_name_l[-2].split('_')[0]
    num_run = 0
    if not cls.isdigit():
##        print(f_name)
        return None
    with open(f_name, 'r') as f:
        save_ = json.load(f)
    try:
        save = {}
        save['dataset'] = dataset
        save['class'] = cls
        save['methods'] = method
        save['num_run'] = num_run
        save['avg_auroc'] = np.mean(save_['TS_AUC'])
        save['std_auroc'] = np.std(save_['TS_AUC'])
        save['avg_f1'] = np.mean(save_['TS_F1'])
        save['std_f1'] = np.std(save_['TS_F1'])
    except:
        print(f_name)
        return
    return save


def calculate_dpad_res(means, stds):
    total_mean = np.mean(means)

    # Step 2: Calculate the total variance
    total_variance = np.mean(stds**2 + (means - total_mean)**2)

    # Step 3: Calculate the total standard deviation
    total_std = np.sqrt(total_variance)
    return total_mean, total_std


if __name__ == "__main__":
    res_df = pd.DataFrame([], columns=['dataset', 'class', 'methods', 'num_run',
                                       'avg_auroc', 'std_auroc', 'avg_f1', 'std_f1'])
    root  = './adbench_RESULTS'                          
    for r, dirs, files in os.walk(root, topdown=False):
        for name in files:
            f_name = os.path.join(r, name)
            if name == 'results.json':
                
                res_dict = read_dpad_save(f_name)
                
                res_df = res_df._append(pd.DataFrame(res_dict, index=[0]), ignore_index=True)


    res_df = res_df[['dataset', 'class', 'methods', 'avg_auroc', 'std_auroc', 'avg_f1', 'std_f1']]
    mean_auc, std_auc = calculate_dpad_res(res_df['avg_auroc'], res_df['std_auroc'])
    mean_f1, std_f1 = calculate_dpad_res(res_df['avg_f1'], res_df['std_f1'])
    print({'mean_auc':mean_auc,
                                                  'std_auc':std_auc,
                                                  'mean_f1': mean_f1,
                                                  'std_f1': std_f1})
    
    final_df = pd.DataFrame([], columns=['dataset', 'mean_auc', 'std_auc', 'mean_f1', 'std_f1'])
    for d in res_df['dataset'].unique():
        tem = res_df[res_df['dataset'] == d]
        mean_auc, std_auc = calculate_dpad_res(tem['avg_auroc'], tem['std_auroc'])
        mean_f1, std_f1 = calculate_dpad_res(tem['avg_f1'], tem['std_f1'])
        
        final_df = final_df._append(pd.DataFrame({'dataset':d,
                                                  'mean_auc':mean_auc,
                                                  'std_auc':std_auc,
                                                  'mean_f1': mean_f1,
                                                  'std_f1': std_f1}, index=[0]), ignore_index=True)
        
