import torch

import torch.nn as nn
import torch.nn.functional as F


class VanilaMLP(nn.Module):
    def __init__(self, input_dim=1000, hidden_dim=64):
        super(VanilaMLP, self).__init__()

        self.hidden_dim = hidden_dim
        self.input_dim = input_dim
        self.n_class = 1
        self.fc1 = nn.Linear(self.input_dim, 512, bias=True)
        self.fc2 = nn.Linear(512, 256, bias=True)
        self.fc3 = nn.Linear(256, 128, bias=True)
        self.fc4 = nn.Linear(128, 1, bias=False)

    def forward(self, x):
        x = F.leaky_relu(self.fc1(x))
        x = F.leaky_relu(self.fc2(x))
        feature = self.fc3(x)
        x = F.leaky_relu(feature)
        x = self.fc4(x)
        return x
