from typing import Dict, Type
from .base import BaseFuseTrainer



class ModelRegistry:
    _models: Dict[str, Type[BaseFuseTrainer]] = {}

    @classmethod
    def register(cls, name: str):
        """Model registration decorator"""
        def wrapper(model_cls):
            cls._models[name] = model_cls
            return model_cls
        return wrapper

    @classmethod
    def get_model_cls(cls, name: str):
        """Get registered model class"""
        if name not in cls._models:
            raise ValueError(f"Model {name} not found in registry")
        return cls._models[name]

    @classmethod
    def get_model(cls, name: str, hparams: dict):
        """Get registered model instance"""
        model_cls = cls.get_model_cls(name)
        return model_cls(hparams)
